<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @generated   2025-06-15 00:00:00
 * @package     bplan-base/globals
 * @subpackage  Services
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Services;


use BplanBase\Globals\Actions\TenantExternalSystem\Create;
use BplanBase\Globals\Actions\TenantExternalSystem\Delete;
use BplanBase\Globals\Actions\TenantExternalSystem\Instantiate;
use BplanBase\Globals\Actions\TenantExternalSystem\Update;
use BplanBase\Globals\Models\TenantExternalSystem;
use Illuminate\Database\Eloquent\Model;


/**
 * Service Class
 *
 * @version     2.1.0 / 2025-06-15
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TenantExternalSystemService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      TenantExternalSystem
     *
     * @version     1.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): Model
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       int|string|TenantExternalSystem $tenantExternalSystem
     *
     * @return      TenantExternalSystem
     *
     * @version     2.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(int|string|Model $tenantExternalSystem): Model
    {
        $Action = new Delete();

        return $Action->execute($tenantExternalSystem);

    } // delete()


    /**
     *
     * @param       int|string|ExternalSystem $externalSystem
     *
     * @return      TenantExternalSystem
     *
     * @version     1.0.0 / 2025-05-29
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function instantiate(int|string|Model $externalSystem): Model
    {
        $Action = new Instantiate();

        return $Action->execute($externalSystem);

    } // instantiate()


    /**
     *
     * @param       int|string|Model $tenantExternalSystem
     *
     * @param       array $attributes
     *
     * @return      TenantExternalSystem
     *
     * @version     2.0.0 / 2025-05-23
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(int|string|Model $tenantExternalSystem, array $attributes): Model
    {
        $Action = new Update();

        return $Action->execute($tenantExternalSystem, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TenantExternalSystemService {}
