<?php
/**
 * Livewire Component
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/globals
 * @subpackage  LivewireComponents
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\Globals\Traits;


/**
 * Livewire Component
 *
 * Spalten für die Sortierung müssen in der Parent-Component definiert werden.
 * Beispiel:
 *
 *      public array $sortColumns = [
 *          'name' => 'Name',
 *          'email' => 'E-Mail'
 *      ];
 *
 * @todo        Die Sortierung könnte optional in der Session abgelegt werden, um sie
 *              dauerhaft zu machen.
 *
 * @version     1.1.0 / 2025-10-01
 * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
trait WithSorting
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     null|string
     */
    public null|string $sortColumn = null;


    /**
     * @var     string
     */
    public string $sortDirection = 'asc';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Fügt automatisch den Listener für sortingChanged hinzu
     *
     * Bestehende Listener in der Klasse werden nicht überschrieben.
     *
     * @version     1.0.0 / 2025-09-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getListeners()
    {
        /*
        **  Listener des Parents abrufen und ergänzen. */
        $parentListeners = property_exists($this, 'listeners') ? $this->listeners : [];

        $traitListener = [
            'sortingChanged' => 'updateSorting',
        ];
        return array_merge($parentListeners, $traitListener);

    } // getListeners()


    /**
     *
     * @version     1.0.0 / 2025-09-20
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function getOrderBy(): array|null
    {
        $orderBy = null;

        if (!empty($this->sortColumn)) {
            $orderBy = [
                [
                    'column' => $this->sortColumn,
                    'direction' => $this->sortDirection,
                ],
            ];
        }
        return $orderBy;

    } // getOrderBy()


    /**
     * Standard-Methode, die von SortSelect aufgerufen wird
     *
     * @param       string $column
     *
     * @param       string $direction
     *
     * @return      void
     *
     * @version     2.0.0 / 2025-10-01
     * @author      Emilio Cannarozzo <emilio.cannarozzo@bplan-solutions.de>
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function updateSorting(null|string $column, null|string $direction): void
    {
        if (!array_key_exists($column, $this->sortColumns)) {
            return;
        }
        $this->sortColumn = $column;
        $this->sortDirection = $direction;

    } // updateSorting()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait WithSorting {}
