<?php
/**
 * Code Generator Loader Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator-loader
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Loaders;


use Illuminate\Database\Schema\Blueprint;


/**
 * Code Generator Loader Class
 *
 * @version     2.0.0 / 2025-02-21
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CodeGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string ALL_SERVERS_KEY
     */
    const ALL_SERVERS_KEY = '*';


    /**
     * @var     int APPENDS_JSONAPI_SCHEMA
     */
    const APPENDS_JSONAPI_SCHEMA       = 1;


    /**
     * @var     int APPENDS_MODEL_ARRAY
     */
    const APPENDS_LARAVEL_MODEL_ARRAY  = 2;


    /**
     * @var     int APPENDS_MODEL_METHOD
     */
    const APPENDS_LARAVEL_MODEL_METHOD = 4;


    /**
     * Wenn der Wert eines Json-Feldes ein Array ist
     *
     * Beispiele:
     *  ["de", "en"]
     *  [{"de":"deutsch"}, {"en":"englisch"}]
     *
     * @var     string JSON_TYPE_ARRAY
     */
    const JSON_TYPE_ARRAY = 'List';


    /**
     * Wenn der Wert eines Json-Feldes ein Objekt ist
     *
     * Beispiel:
     *  {"de":"deutsch", "en":"englisch"}
     *
     * @var     string JSON_TYPE_OBJECT
     */
    const JSON_TYPE_OBJECT = 'Hash';


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     bool $_awaitingStart
     */
    private static $_awaitingStart = false;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Blueprint $Blueprint
     *
     * @param       array $additionalSettings
     *
     * @version     1.0.0 / 2025-02-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Blueprint $Blueprint, array $additionalSettings = [])
    {
        if (config('code-generator.active') === true && class_exists('BplanBase\\CodeGenerator\\Generators\\CodeGenerator')) {
            new \BplanBase\CodeGenerator\Generators\CodeGenerator($Blueprint, $additionalSettings);
        }
    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      void
     *
     * @version     1.0.0 / 2025-02-21
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function awaitingStart(bool|null $willStart = null)
    {
        if ($willStart === null) {
            return self::$_awaitingStart;
        }
        return self::$_awaitingStart = $willStart;

    } // awaitingStart()


} // class CodeGenerator {}
