<?php
/**
 * Package Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator-loader
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator;


use Illuminate\Support\ServiceProvider;


/**
 * Package Service Provider Class
 *
 * @version     1.2.0 / 2025-05-30
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LoaderServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string $_basePath
     */
    protected $_basePath;


    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var         bool $defer
     */
    protected $defer = false;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Bootstrap the application events.
     *
     * @return      void
     *
     * @version     1.1.0 / 2025-03-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            /*
            **  Ermöglicht das Veröffentlichen der Konfigurationsdatei. */
            $this->publishes([
                    $this->_basePath.'/config/code-generator.php' => config_path('code-generator.php'),

                ], 'config'
            );
        }
    } // boot()


    /**
     * Register the service provider.
     *
     * @return      void
     *
     * @version     1.2.0 / 2025-05-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function register(): void
    {
        $this->_basePath = str_replace('\\', '/', realpath(__DIR__.'/..'));

        if ($this->app->runningInConsole()) {
            /*
            **  Lädt die Konfiguration des Pakets. */
            $this->mergeConfigFrom($this->_basePath.'/config/code-generator.php', 'code-generator');
            /*
            **  Prüft das Vorhandensein des CodeGenerator-Verzeichnisses.
            **  Wenn das Verzeichnis nicht existiert, dann bedeutet das in der Regel, dass der
            **  Code-Generator das erste Mal gestartet wurde. Für diesen Fall soll das Routing
            **  deaktiviert. */
            if (file_exists(storage_path('app/build/CodeGenerator')) === false) {
                config(['code-generator.skip-routing' => true]);
            }
        }
    } // register()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class LoaderServiceProvider extends ServiceProvider {}
