<?php
/**
 * CodeGenerator Configuration
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator-loader
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Active
    |--------------------------------------------------------------------------
    |
    | Der CodeGenerator muss explizit aktiviert werden. So soll verhindert werden, dass er zum
    | Beispiel in einem Environment, in dem nicht am Backend gearbeitet wird, mit jeder Migration
    | die Klassen modifiziert.
    |
    */
    'active' => (bool) env('CODE_GENERATOR_ACTIVE', false),

    /*
    |--------------------------------------------------------------------------
    | Creates
    |--------------------------------------------------------------------------
    |
    | Ein Array der definiert welche Codes generiert werden sollen.
    |
    | JsonApi  > erzeugt Policy-, Request-, Schema- und Server-Klassen sowie Routen-Definitionen.
    | Livewire > erzeugt Livewire-Components
    | CSharp   > erzeugt NewtonSoft Json-Klassen
    |
    | Die Reihenfolge der Werte im Array steuert die Reihenfolge der Abarbeitung.
    | Prinzipiell ist die Reihenfolge unerheblich. Um aber von vornherein Probleme zu vermeiden,
    | sollte die Erzeugung der Codes für Laravel an erster Stelle stehen und erst danach sollten die
    | auf der Laravel-Basis aufsetzenden Pakete bedient werden.
    | Die Codes für C# setzen nicht auf Laravel auf und können dementsprechend zu einem beliebigen
    | Zeitpunkt erzeugt werden.
    |
    */
    'creates' => [
        'Laravel' => true,
        'Livewire' => true,
        'JsonApi' => true,
        'CSharp' => env('CODE_GENERATOR_CREATE_CSHARP', true),
    ],

    /*
    |--------------------------------------------------------------------------
    | Force Create Build Files
    |--------------------------------------------------------------------------
    |
    | Aktiviert die Funktion, dass Bild-Dateien immer geschrieben werden.
    |
    */
    'force-create-build-files' => env('CODE_GENERATOR_FORCE_CREATE_BUILD_FILES', false),

    /*
    |--------------------------------------------------------------------------
    | JsonApi Namespace
    |--------------------------------------------------------------------------
    |
    | todo  Eigentlich sollte dieser Wert aus der config-Datei des JasonApi-Pakets gelesen werden.
    |
    */
    'jsonapi-namespace' => 'JsonApi',

    /*
    |--------------------------------------------------------------------------
    | Default Server
    |--------------------------------------------------------------------------
    |
    | Der Name des Standard-Servers.
    |
    | Dieser Server wird in "jsonapi-servers" automatisch auf TRUE gesetzt.
    |
    | @todo     Noch nicht implementiert.
    |
    */
    'jsonapi-default-server' => 'Data',

    /*
    |--------------------------------------------------------------------------
    | Servers
    |--------------------------------------------------------------------------
    |
    | Ein Array mit den Namen der Json::Api Server.
    |
    | Nur für die Elemente deren Wert TRUE ist, werden die JsonApi-Klassen erzeugt.
    |
    | Im Normalfall muss jeder Server seine eigenen Klassen haben. Wenn zwischen den Klassen der
    | einzelnen Server kein Unterschied besteht, dann können auch nur Klassen für einen Server
    | erzeugt werden. Diese Klasse können dann in der Server.php des/der anderen Server referenziert
    | werden.
    |
    */
    'jsonapi-servers' => [
        'Data' => true,
        'Terminal' => true,
    ],

    /*
    |--------------------------------------------------------------------------
    | Skip Routing
    |--------------------------------------------------------------------------
    |
    | Mit dieser Konfigurationseinstellung lässt sich das Routing aussetzen. Das ist zum Beispiel
    | dann erforderlich, wenn das Laden der Routen, das immer vor dem Start des CodeGenerators
    | erfolgt, zu einem Fehler führt (z.B. wegen fehlender oder defekter Schema-Klassen).
    |
    | Anstatt das Laden der Routendateien dadurch zu verhindern, dass der Code in der Routen-Datei
    | deaktiviert (auskommentiert) wird, kann diese Einstellung verwendet werden.
    | Voraussetzung dafür ist, dass die Routendateien entsprechend präpariert sind.
    |
    */
    'skip-routing' => env('CODE_GENERATOR_SKIP_ROUTING', false),

    /*
    |--------------------------------------------------------------------------
    | Test-Mode
    |--------------------------------------------------------------------------
    |
    | De-/aktiviert den Testmodus.
    |
    | Im Test-Modus werden keine Dateien im Projektverzeichnis erzeugt oder überschrieben.
    |
    */
    'test-mode' => env('CODE_GENERATOR_TEST_MODE', null),

];
