<?php
/**
 * Base File Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator;


use Bplan\LaravelCodeGenerator\Definitions\TypeDefinition;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;


/**
 * Base File Generator Class
 *
 * @version     1.4.0 / 2024-10-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseFileGenerator extends BaseGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_FieldDefinitions
     */
    protected $_FieldDefinitions;


    /**
     * @var     string $_modelType
     */
    protected $_modelType;


    /**
     * @var     string $_stubPath
     */
    protected $_stubPath;


    /**
     * @var     string $_tableName
     */
    protected $_tableName;


    /**
     * @var     _TypeDefinition $_TypeDefinition
     */
    protected $_TypeDefinition;


    /**
     * @var     string $_typeName
     */
    protected $_typeName;


    /**
     * @var     string $_typeNamePlural
     */
    protected $_typeNamePlural;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @version     3.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(TypeDefinition $TypeDefinition)
    {
        $this->_TypeDefinition = $TypeDefinition;

        $this->_init();
        $this->_process();

    } // __construct()


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        $this->_modelType = $this->_TypeDefinition->getModelType();
        $this->_typeName = $this->_TypeDefinition->getTypeName(singular: true);
        $this->_typeNamePlural = $this->_TypeDefinition->getTypeName(singular: false);

        parent::_init();

        $this->_tableName = $this->_TypeDefinition->getTableName();
        $this->_FieldDefinitions = $this->_TypeDefinition->getFieldDefinitions($this->_tableName);

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BaseFileGenerator extends BaseGenerator {}
