<?php
/**
 * Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Policies
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\CSharp;


use Bplan\LaravelCodeGenerator\Definitions\FieldDefinition;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\CSharpFileGenerator;


/**
 * Generator Class
 *
 * @version     2.0.0 / 2024-10-20
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class NewtonSoftClassGenerator extends CSharpFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = true;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'CSharp/NewtonSoft';


    /**
     * @var     array $_jsonProperties
     */
    protected $_idProperty;


    /**
     * @var     array $_jsonProperties
     */
    protected $_jsonProperties = [];


    /**
     * @var     array $_technicalProperties
     */
    protected $_technicalProperties = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = 'csharp.newtonsoft';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/newtonsoft-class.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('properties', $this->_preparePropertyReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _preparePropertyReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $fileContents = file_get_contents($this->_stubPath.'/snippets/newtonsoft-class/property.stub');

        $fileContents = parent::replacePlaceholder('json-name', $this->_idProperty['json-name'], $fileContents);
        $fileContents = parent::replacePlaceholder('name', $this->_idProperty['name'], $fileContents);
        $fileContents = parent::replacePlaceholder('type', $this->_idProperty['type'], $fileContents);

        $replacement = $fileContents;

        ksort($this->_technicalProperties);

        foreach ($this->_technicalProperties as $property) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/newtonsoft-class/property.stub');

            $fileContents = parent::replacePlaceholder('json-name', $property['json-name'], $fileContents);
            $fileContents = parent::replacePlaceholder('name', $property['name'], $fileContents);
            $fileContents = parent::replacePlaceholder('type', $property['type'], $fileContents);

            $replacement .= $fileContents;
        }
        ksort($this->_jsonProperties);

        foreach ($this->_jsonProperties as $property) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/newtonsoft-class/property.stub');

            $fileContents = parent::replacePlaceholder('json-name', $property['json-name'], $fileContents);
            $fileContents = parent::replacePlaceholder('name', $property['name'], $fileContents);
            $fileContents = parent::replacePlaceholder('type', $property['type'], $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _preparePropertyReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinition();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processTypeDefinition(): self
    {
        foreach ($this->_TypeDefinition->getFieldDefinitions($this->_tableName) as $FieldDefinition) {
            if ($FieldDefinition->getAttribute('isForeignKey') === true) {
                continue;
            }
            $columnName = $FieldDefinition->getAttribute('columnName');
            $type = $FieldDefinition->getAttribute('type');

            $jsonName = $FieldDefinition->getName('camel');
            $varName = $FieldDefinition->getName('studly');

            switch ($type) {
                case 'bigInteger':
                    $abstractType = 'integer';
                    break;

                case 'boolean':
                    $abstractType = 'bool';
                    break;

                case 'datetime':
                case 'timestamp':
                    $abstractType = 'DateTime';
                    break;

                case 'enum':
                case 'geometry':
                case 'json':
                    $abstractType = 'string';
                    break;

                default:
                    $abstractType = $type;
            }
            if ($columnName === 'id') {
                $abstractType = 'string';
                $varName = 'ID';

                $this->_idProperty = [
                    'json-name' => $jsonName,
                    'type' => $abstractType,
                    'name' => $varName,
                ];
                continue;

            } elseif (FieldDefinition::isTechnicalField($columnName)) {

                $this->_technicalProperties[$jsonName] = [
                    'json-name' => $jsonName,
                    'type' => $abstractType,
                    'name' => $varName,
                ];
                continue;
            }
            $this->_jsonProperties[$jsonName] = [
                'json-name' => $jsonName,
                'type' => $abstractType,
                'name' => $varName,
            ];
        }
        return $this;

    } // _processTypeDefinition()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'.cs', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class NewtonSoftClassGenerator extends CSharpFileGenerator {}
