<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi;


use Illuminate\Support\Str;


use Bplan\LaravelCodeGenerator\Enums\ModelType;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     3.0.0 / 2024-10-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PolicyGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'app/Policies';


    /**
     * @var     array $_relationFields
     */
    protected $_relationFields = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = 'jsonapi.policy';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addRelation(string $name): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            $key .= 'Failure';
            $name .= 'Failure';
        }
        $this->_relationFields[$key] = $name;

        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            'App\\Models\\'.$this->_typeName,
            'App\\Models\\User',
        ]);
        return parent::_initUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/policy.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', 'App\\Policies', $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.1 / 2024-10-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareMethodReplacement(): string
    {
        ksort($this->_relationFields);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_relationFields as $relationName) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/policy/method.stub');

            $fileContents = parent::replacePlaceholder('method', $relationName, $fileContents);
            $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinition();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_TypeDefinition->getAdditionalRelations() as $additionalRelation) {
            $methodName = Str::studly($additionalRelation['relationName']);

            $this->_addRelation($methodName);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getColumnName();
                $relatedTable = $BackReference->getTableName();

                $RelatedTypeDefinition = CodeGenerator::getTypeDefinition($relatedTable);

                $pivotTables = $RelatedTypeDefinition->getPivotTables();
                /*
                **  ForeignId-Felder haben nicht zwingend eine Constraint (siehe users.current_team_id). Aus dem
                **  Grund muss hier überprüft werden ob es eine entsprechende Definition gibt. */
                if ($BackReference->getModelType() === ModelType::Pivot->name && isset($pivotTables[$this->_tableName])) {
                    $methodName = Str::studly($pivotTables[$this->_tableName]);

                } else {
                    $methodName = $BackReference->getTableName('studly');

                    $foreignKey = $RelatedTypeDefinition->getForeignKey($columnName);

                    if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                        $methodName = Str::studly($foreignKey['reverseRelationName']);
                    }
                }
                $this->_addRelation($methodName);
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processTypeDefinition(): self
    {
        /*
        **  Foreign-Keys abarbeiten. */
        foreach ($this->_FieldDefinitions as $FieldDefinition) {
            if ($FieldDefinition->isForeignKey() === true) {
                $ForeignKeyDefinition = $FieldDefinition->getForeignKeyDefinition();

                if ($ForeignKeyDefinition === null) {
                    continue;
                }
                $methodName = $ForeignKeyDefinition->getName('studly');

                $this->_addRelation($methodName);
            }
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_initUses();

        return $this;

    } // _processTypeDefinition()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Policy-Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'Policy.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PolicyGenerator extends JsonApiFileGenerator {}
