<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Klasse UserRequest      currentTeamId
 *
 * @todo        uses prüfen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi;


use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     3.1.0 / 2024-10-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RequestGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     array $_foreignKeys
     */
    protected $_foreignKeys = [];


    /**
     * @var     integer $_maxFieldNameLength
     */
    protected $_maxFieldNameLength = 0;


    /**
     * @var     array $_rules
     */
    protected $_rules = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = 'jsonapi.request';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/request.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('rules', $this->_prepareRuleReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareRuleReplacement(): string
    {
        $padding = str_repeat(' ', 12);

        ksort($this->_rules);
        /*
        **  Ersetzungs-String für die Felddefinitionen zusammenstellen. */
        $replacement = '';

        if (!empty($this->_rules)) {
            foreach ($this->_rules as $field => $rules) {
                if (is_array($rules)) {
                    $replacement .= "\n".$padding
                        .str_pad("'".$field."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                        .' => [';

                    $separator = '';

                    foreach ($rules as $rule) {
                        if (strpos($rule, 'Rule::') !== false) {
                            $quotedRule = $rule;

                        } else {
                            $quotedRule = "'".$rule."'";
                        }
                        $replacement .= $separator.$quotedRule;
                        $separator = ', ';
                    }
                    $replacement .= '],';

                } else {
                    $replacement .= "\n".$padding
                        .str_pad("'".$field."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                        .' => '.$rules.',';
                }
            }
            $replacement .= "\n";
        }
        if (!empty($this->_foreignKeys)) {
            foreach ($this->_foreignKeys as $name) {
                $replacement .= "\n".$padding
                    .str_pad("'".$name."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                    .' => JsonApiRule::toOne(),';
            }
            $replacement .= "\n";
        }
        return $replacement;

    } // _prepareRuleReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinition();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processTypeDefinition(): self
    {
        /*
        **  Technische/automatische Felder, die übersprungen werden sollen. */
        $skipColumns = [
            'created_at' => true,
            'deleted_at' => true,
            'updated_at' => true,
        ];
        /*
        **  Felddefinitionen zusammenstellen. */
        foreach ($this->_FieldDefinitions as $FieldDefinition) {
            if ($FieldDefinition->getAttribute('autoIncrement') === true) {
                continue;
            }
            $columnName = $FieldDefinition->getAttribute('columnName');

            if (isset($skipColumns[$columnName])) {
                continue;
            }
            $nameCamelCase = $FieldDefinition->getName('camel');

            if ($FieldDefinition->getAttribute('isForeignKey')) {
                $ForeignKeyDefinition = $FieldDefinition->getForeignKeyDefinition();
                /*
                **  Die ForeignKey-Felder werden hier nur gesammelt aber nicht weiter verarbeitet.
                **  Verwendet wird die Liste anschließend in der Methode _prepareRuleReplacement(). */
                $foreignKeyName = $ForeignKeyDefinition->getName('slug');

                $this->_foreignKeys[] = $foreignKeyName;

                $this->_maxFieldNameLength = max($this->_maxFieldNameLength, strlen($foreignKeyName));

                $this->_addUse('LaravelJsonApi\\Validation\\Rule as JsonApiRule');

                continue;
            }
            $this->_maxFieldNameLength = max($this->_maxFieldNameLength, strlen($nameCamelCase));

            $rules = $FieldDefinition->getAttribute('rules');
            $ruleType = $FieldDefinition->getAttribute('ruleType');
            $type = $FieldDefinition->getAttribute('type');
            $typeTranslated = $FieldDefinition->getAttribute('abstractType');

            if ($rules !== null) {
                $this->_rules[$nameCamelCase] = $rules;

                continue;
            }
            $fieldRules = [];

            if ($FieldDefinition->getAttribute('nullable') === true) {
                $fieldRules['nullable'] = 'nullable';

            } else {
                $fieldRules['nullable'] = 'required';
            }
            if ($ruleType !== null) {
                $fieldRules['type'] = $ruleType;

                if ($FieldDefinition->getAttribute('length') !== null) {
                    $fieldRules[] = 'max:'.$FieldDefinition->getAttribute('length');
                }
                $this->_rules[$nameCamelCase] = $fieldRules;

                continue;
            }
            switch ($typeTranslated) {
                case 'bool':
                    $fieldRules = 'JsonApiRule::boolean()';

                    $this->_addUse('LaravelJsonApi\\Validation\\Rule as JsonApiRule');

                    break;

                case 'datetime':
                    $fieldRules['type'] = 'date';
                    break;

                case 'integer':
                    $fieldRules['type'] = 'integer';
                    break;

                case 'string':
                    if ($type === 'json') {
                        $fieldRules['type'] = 'json';
                    } else {
                        $fieldRules['type'] = 'string';
                    }
                    if ($FieldDefinition->getAttribute('length') !== null) {
                        $fieldRules[] = 'max:'.$FieldDefinition->getAttribute('length');
                    }
                    break;

                default:
            }
            $this->_rules[$nameCamelCase] = $fieldRules;
        }
        $this->_initUses();

        return $this;

    } // _processTypeDefinition()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Schema-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach (config('code-generator.jsonapi-servers') as $server => $status) {
            if ($status === false) {
                continue;
            }
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $fileContents = parent::replacePlaceholder('namespace', 'App\\JsonApi\\'.$server.'\\'.$this->_typeNamePlural, $baseFileContents);
            /*
            **  Schema-Klasse schreiben. */
            $this->_filePath = 'app/JsonApi/'.$server.'/'.$this->_typeNamePlural;

            parent::_writeFileContents($this->_typeName.'Request.php', $fileContents);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RequestGenerator extends JsonApiFileGenerator {}
