<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi;


use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\BaseGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApiGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     2.1.0 / 2024-10-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ServerGenerator extends JsonApiGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     array $_schemaClasses
     */
    protected $_schemaClasses = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = 'jsonapi.server';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _getPreparedFileContents(): string
    {
        $schemaReplacement = $this->_prepareSchemaReplacement();
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/server.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('schema-classes', $schemaReplacement, $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareSchemaReplacement(): string
    {
        ksort($this->_schemaClasses);

        $padding = str_repeat(' ', 12);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_schemaClasses as $schemaClass) {
            $replacement .= "\n".$padding.$schemaClass.',';
        }
        return $replacement;

    } // _prepareSchemaReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinitions();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processTypeDefinitions(): self
    {
        foreach ($this->_typeDefinitions as $TypeDefinition) {
            $typeName = $TypeDefinition->getTypeName(singular: true);
            $typeNamePlural = $TypeDefinition->getTypeName(singular: false);

            $this->_schemaClasses[strtolower($typeName)] = $typeNamePlural.'\\'.$typeName.'Schema::class';
        }
        return $this;

    } // _processTypeDefinitions()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Server-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach (config('code-generator.jsonapi-servers') as $server => $status) {
            if ($status === false) {
                continue;
            }
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $fileContents = parent::replacePlaceholder('lower-server', strtolower($server), $baseFileContents);
            $fileContents = parent::replacePlaceholder('namespace', 'App\\JsonApi\\'.$server, $fileContents);
            /*
            **  Server-Klasse schreiben. */
            $this->_filePath = 'app/JsonApi/'.$server;

            parent::_writeFileContents('Server.php', $fileContents);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ServerGenerator extends JsonApiGenerator {}
