<?php
/**
 * Laravel Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @todo        Appointment
 *                  Methode equipmentItems  >   return $this->belongsToMany(EquipmentItem::class)->withPivot('amount');
 *                  Token-Methoden auslagern.
 *
 * @todo        User        fillable > current_team_id
 *
 * @todo        Visitor     Methode appointments    >   return $this->belongsToMany(Appointment::class)->withPivot('token');
 *
 * @todo        VisitType   Methode appointments(): HasManyThrough dynamisch erzeugen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\Laravel;


use Illuminate\Support\Str;


use Bplan\LaravelCodeGenerator\Enums\ModelType;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     3.0.0 / 2024-10-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ModelGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * @var     integer $_castMaxFieldNameLength
     */
    protected $_castMaxFieldNameLength = 0;


    /**
     * @var     array $_casts
     */
    protected $_casts = [];


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'app/Models';


    /**
     * @var     array $_fillableFields
     */
    protected $_fillableFields = [];


    /**
     * @var     array $_guardedFields
     */
    protected $_guardedFields = [];


    /**
     * @var     array $_hiddenFields
     */
    protected $_hiddenFields = [];


    /**
     * @var     array $_relationFields
     */
    protected $_relationFields = [];


    /**
     * @var     array $_timestamped
     */
    protected $_timestamped = false;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = 'laravel.model';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $methodName
     *
     * @param       string $columnName
     *
     * @param       string $relationType
     *
     * @param       string $targetClass
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addRelation(string $methodName, string $columnName, string $relationType, string $targetClass): self
    {
        $key = strtolower($methodName);

        if (isset($this->_relationFields[$key])) {
            $key .= 'Failure';
        }
        $this->_relationFields[$key] = [
            'columnName' => $columnName,
            'methodName' => $methodName,
            'relationType' => $relationType,
            'targetClass' => $targetClass,
        ];
        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _initUses(): self
    {
        if ($this->_modelType === ModelType::Model->name) {
            $this->_addUse('Illuminate\\Database\\Eloquent\\Model');
        } else {
            $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\Pivot');
        }
        return parent::_initUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_modelType === ModelType::Model->name) {
            $fileContents = file_get_contents($this->_stubPath.'/model.stub');
        } else {
            $fileContents = file_get_contents($this->_stubPath.'/model.pivot.stub');
        }
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('casts', $this->_prepareCastReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('fillable-fields', $this->_prepareFillableFieldReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('guarded-fields', $this->_prepareGuardedFieldReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('hidden-fields', $this->_prepareHiddenFieldReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('timestamped', ($this->_timestamped === true ? 'true' : 'false'), $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('traits', $this->_prepareTraitReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.1 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareCastReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_casts)) {
            ksort($this->_casts);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_casts as $field => $type) {
                $replacement .= "\n".$padding.str_pad('\''.$field.'\'', $this->_castMaxFieldNameLength + 2, ' ', STR_PAD_RIGHT).' => \''.$type.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareCastReplacement()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareFillableFieldReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_fillableFields)) {
            ksort($this->_fillableFields);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_fillableFields as $field) {
                $replacement .= "\n".$padding.'\''.$field.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareFillableFieldReplacement()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareGuardedFieldReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_guardedFields)) {
            ksort($this->_guardedFields);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_guardedFields as $field) {
                $replacement .= "\n".$padding.'\''.$field.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareGuardedFieldReplacement()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareHiddenFieldReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_hiddenFields)) {
            ksort($this->_hiddenFields);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_hiddenFields as $field) {
                $replacement .= "\n".$padding.'\''.$field.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareHiddenFieldReplacement()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareMethodReplacement(): string
    {
        ksort($this->_relationFields);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_relationFields as $relation) {
            $relationType = $relation['relationType'];

            $fileContents = file_get_contents($this->_stubPath.'/snippets/model/method.'.$relationType.'.stub');

            $fileContents = parent::replacePlaceholder('column', $relation['columnName'], $fileContents);
            $fileContents = parent::replacePlaceholder('method', $relation['methodName'], $fileContents);
            $fileContents = parent::replacePlaceholder('target-class', $relation['targetClass'].'::class', $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinition();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getColumnName();
                $relatedTable = $BackReference->getTableName();

                $RelatedTypeDefinition = CodeGenerator::getTypeDefinition($relatedTable);

                $pivotTables = $RelatedTypeDefinition->getPivotTables();
                /*
                **  ForeignId-Felder haben nicht zwingend eine Constraint (siehe users.current_team_id). Aus dem
                **  Grund muss hier überprüft werden ob es eine entsprechende Definition gibt. */
                if ($BackReference->getModelType() === ModelType::Pivot->name && isset($pivotTables[$this->_tableName])) {
                    $methodName = str::camel($pivotTables[$this->_tableName]);

                    $relationType = 'BelongsToMany';

                    $targetClass = Str::studly(Str::singular($pivotTables[$this->_tableName]));

                } else {
                    $foreignKey = $RelatedTypeDefinition->getForeignKey($columnName);
                    $methodName = $BackReference->getTableName('camel');

                    $relationType = 'HasMany';

                    if (!empty($foreignKey['reverseRelationName'])) {
                        $methodName = Str::camel($foreignKey['reverseRelationName']);
                    }
                    $targetClass = $BackReference->getTableName('studly', singular: true);
                }
                $this->_addRelation($methodName, $columnName, $relationType, $targetClass);

                $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\'.$relationType);
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processTypeDefinition(): self
    {
        /*
        **  Foreign-Keys abarbeiten. */
        foreach ($this->_FieldDefinitions as $FieldDefinition) {
            $columnName = $FieldDefinition->getName();
            $type = $FieldDefinition->getAttribute('type');

            if ($FieldDefinition->getAttribute('autoIncrement') === true) {
                continue;
            }
            switch ($columnName) {
                case 'deleted_at':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'datetime';
                    $this->_guardedFields[$columnName] = $columnName;

                    $this->_addTrait('Illuminate\\Database\\Eloquent\\SoftDeletes');

                    continue 2;
                    break;

                case 'created_at':
                case 'updated_at':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'datetime';
                    $this->_guardedFields[$columnName] = $columnName;
                    $this->_timestamped = true;

                    continue 2;
                    break;
            }
            if ($FieldDefinition->isForeignKey() === true) {
                $ForeignKeyDefinition = $FieldDefinition->getForeignKeyDefinition();

                if ($ForeignKeyDefinition === null) {
                    continue;
                }
                $methodName = $ForeignKeyDefinition->getName('camel');

                // $relatedTable = $ForeignKeyDefinition->getRelatedTable();

                // $RelatedTypeDefinition = CodeGenerator::getTypeDefinition($relatedTable);

                // $foreignKey = $RelatedTypeDefinition->getForeignKey($columnName);

                // if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                //     $methodName = Str::camel($foreignKey['reverseRelationName']);
                // }
                $this->_addRelation($methodName, $columnName, 'BelongsTo', Str::singular($ForeignKeyDefinition->getRelatedTable('studly')));
                $this->_addUse('Illuminate\Database\Eloquent\Relations\BelongsTo');
            }
            if ($FieldDefinition->getAttribute('guarded') === true) {
                $this->_guardedFields[$columnName] = $columnName;
            } else {
                $this->_fillableFields[$columnName] = $columnName;
            }
            if ($FieldDefinition->getAttribute('hidden') === true) {
                $this->_hiddenFields[$columnName] = $columnName;
            }
            switch ($type) {
                case 'boolean':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'boolean';
                    break;

                case 'json':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'object';
                    break;

                case 'timestamp':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'datetime';
                    break;
            }
            if (($individualCast = $FieldDefinition->getAttribute('cast')) !== null) {
                $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($individualCast));
                $this->_casts[$columnName] = $individualCast;
            }
        }
        $this->_processBackReferences();
        $this->_initTraits();
        $this->_initUses();

        return $this;

    } // _processTypeDefinition()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Model-Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ModelGenerator extends LaravelFileGenerator {}
