<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\Laravel;


use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     2.0.0 / 2024-10-22
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RepositoryGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'app/Repositories';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = 'laravel.repository';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse('App\\Models\\'.$this->_typeName);

        return parent::_initUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/repository.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Repository-Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'Repository.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RepositoryGenerator extends LaravelFileGenerator {}
