<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi;


use Bplan\LaravelCodeGenerator\Enums\Generator;
use Bplan\LaravelCodeGenerator\Enums\ModelType;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;
use Illuminate\Support\Str;


/**
 * JasonApi Code Generator Class
 *
 * @version     4.2.0 / 2024-12-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PolicyGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir = 'app';


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Policies';


    /**
     * @var     string $_modelNamespace
     */
    private $_modelNamespace = 'App\\Models';


    /**
     * @var     string $_modelNamespace
     */
    protected $_namespace = 'App\\Policies';


    /**
     * @var     array $_relationFields
     */
    private $_relationFields = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiPolicy->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addRelation(string $name): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Duplicate relation ['.$name.']');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] = $this->_relationFields[$key];
            }
            $this->_errors[$key][] = $name;

            $key .= 'Failure';
            $name .= 'Failure';
        }
        $this->_relationFields[$key] = $name;

        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        if ($this->_TypeDefinition->isForPackage()) {
            $packageNamespace = $this->_TypeDefinition->getPackageNamespace();

            $this->_baseDir = 'src';
            $this->_modelNamespace = $packageNamespace.'\\Models';
            $this->_namespace = $packageNamespace.'\\Policies';
            $this->_package = $this->_TypeDefinition->getPackageName();
        }
        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            $this->_modelNamespace.'\\'.$this->_typeName,
            'App\\Models\\User',
        ]);
        return parent::_initUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/policy.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.1 / 2024-10-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareMethodReplacement(): string
    {
        ksort($this->_relationFields);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_relationFields as $relationName) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/policy/method.stub');

            $fileContents = parent::replacePlaceholder('method', $relationName, $fileContents);
            $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinition();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_TypeDefinition->getAdditionalRelations() as $additionalRelation) {
            $methodName = Str::studly($additionalRelation['relationName']);

            $this->_addRelation($methodName);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getColumnName();
                $relatedTable = $BackReference->getTableName();

                $RelatedTypeDefinition = CodeGenerator::getTypeDefinition($relatedTable);

                $pivotTables = $RelatedTypeDefinition->getPivotTables();
                /*
                **  ForeignId-Felder haben nicht zwingend eine Constraint (siehe users.current_team_id). Aus dem
                **  Grund muss hier überprüft werden ob es eine entsprechende Definition gibt. */
                if ($BackReference->getModelType() === ModelType::Pivot->name && isset($pivotTables[$this->_tableName])) {
                    $TypeDefinition = CodeGenerator::getTypeDefinition($pivotTables[$this->_tableName]);

                } else {
                    $TypeDefinition = CodeGenerator::getTypeDefinition($BackReference->getTableName());
                }
                $foreignKey = $RelatedTypeDefinition->getForeignKey($columnName);
                $methodName = $TypeDefinition->getTypeName('studly', singular: false);

                if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    $methodName = Str::studly($foreignKey['reverseRelationName']);
                }
                $this->_addRelation($methodName);
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processTypeDefinition(): self
    {
        /*
        **  Foreign-Keys abarbeiten. */
        foreach ($this->_FieldDefinitions as $FieldDefinition) {
            if ($FieldDefinition->isForeignKey() === true) {
                $ForeignKeyDefinition = $FieldDefinition->getForeignKeyDefinition();

                if ($ForeignKeyDefinition === null) {
                    continue;
                }
                $methodName = $ForeignKeyDefinition->getName('studly');

                $this->_addRelation($methodName);
            }
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_initUses();

        return $this;

    } // _processTypeDefinition()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Policy-Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'Policy.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PolicyGenerator extends JsonApiFileGenerator {}
