<?php
/**
 * Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator;


use Illuminate\Support\ServiceProvider;


use Bplan\LaravelCodeGenerator\Providers\EventServiceProvider;


/**
 * Service Provider Class
 *
 * @version     1.1.0 / 2024-10-14
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PackageServiceProvider extends ServiceProvider
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string $_basePath
     */
    protected $_basePath;


    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var         bool $defer
     */
    protected $defer = false;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Bootstrap the application events.
     *
     * @return      void
     *
     * @version     1.1.0 / 2024-10-14
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot(): void
    {
        $this->loadTranslationsFrom($this->_basePath.'/lang', 'code-generator');

        if ($this->app->runningInConsole()) {
            /*
            **  Published die Hilfsklasse. */
            $this->publishes([
                $this->_basePath.'/resources/publish/CodeGenerator.php' => app_path('Generators/CodeGenerator.php'),

                ], 'class'
            );
            /*
            **  Ermöglicht das Veröffentlichen der Konfigurationsdatei. */
            $this->publishes([
                    $this->_basePath.'/config/code-generator.php' => config_path('code-generator.php'),

                ], 'config'
            );
        }
    } // boot()


    /**
     * Register the service provider.
     *
     * @return      void
     *
     * @version     1.0.0 / 2024-10-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function register(): void
    {
        $this->_basePath = str_replace('\\', '/', realpath(__DIR__.'/..'));
        /*
        **  Lädt die Konfiguration des Pakets. */
        $this->mergeConfigFrom($this->_basePath.'/config/code-generator.php', 'code-generator');
        /*
        **  EventServiceProvider registrieren. */
        $this->app->register(EventServiceProvider::class);

    } // register()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PackageServiceProvider extends ServiceProvider {}
