<?php
/**
 * Code Generator Definition Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Definitions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Definitions;


use Illuminate\Support\Str;


use Bplan\LaravelCodeGenerator\Traits\DefinitionAttributes;


/**
 * Code Generator Definition Class
 *
 * @version     2.0.0 / 2024-11-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ForeignKeyDefinition
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use DefinitionAttributes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $attributes)
    {
        $this->_init($attributes);

    } // __construct()


    /**
     *
     * @param       array $attributes
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _init(array $attributes): void
    {
        $columnName = $attributes['columns'][0];
        $relatedTable = $attributes['on'];

        unset($attributes['algorithm']);
        unset($attributes['columns']);
        unset($attributes['on']);

        $attributes['columnName'] = $columnName;
        $attributes['name'] = Str::camel(Str::replaceLast('_id', '', $columnName));
        $attributes['relatedTable'] = $relatedTable;

        $this->_attributes = $attributes;

        ksort($this->_attributes);

    } // _init()


    /**
     *
     * @param       string|null $caseStyle
     *              Steuert die Schreibweise des zurückgegebenen Tabellennamen.
     *              Beispiele anhand der Typen "appointments" und "entry_points":
     *
     *                  Parameter       Rückgabe
     *                  camel       >   appointments  /  entryPoints
     *                  slug        >   appointments  /  entry-points
     *                  studly      >   Appointments  /  EntryPoints
     *                  null|snake  >   appointments  /  entry_points
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRelatedTable(null|string $caseStyle = null): string
    {
        switch ($caseStyle) {
            case 'camel':
                return Str::camel($this->_attributes['relatedTable']);
                break;

            case 'slug':
                return Str::slug($this->_attributes['relatedTable']);
                break;

            case 'studly':
                return Str::studly($this->_attributes['relatedTable']);
                break;

            case 'snake':
            default:
                return $this->_attributes['relatedTable'];
        }
    } // getRelatedTable()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getName(string $caseStyle = null): string
    {
        switch ($caseStyle) {
            case 'studly':
                return Str::studly($this->_attributes['name']);
                break;

            case 'slug':
                return Str::slug(Str::snake($this->_attributes['name']));
                break;

            default:
                return $this->_attributes['name'];
        }
    } // getName()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRelationName(): string
    {
        return Str::slug(Str::replaceLast('_id', '', $this->_attributes['columnName']), '-');

    } // getRelationName()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getResourceName(): string
    {
        return Str::slug($this->_attributes['relatedTable']);

    } // getResourceName()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getTypeName(): string
    {
        return Str::studly(Str::singular($this->_attributes['relatedTable']));

    } // getTypeName()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ForeignKeyDefinition {}
