<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator;


use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi\RouteGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi\ServerGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     1.3.0 / 2024-10-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class JsonApiGenerator extends BaseGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_stubPath
     */
    protected $_stubPath;


    /**
     * @var     array $_typeDefinitions
     */
    protected $_typeDefinitions;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $typeDefinition
     *
     * @version     2.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $typeDefinitions)
    {
        $this->_typeDefinitions = $typeDefinitions;

        $this->_stubPath = CodeGenerator::getStubPath('jsonapi');

        $this->_init();
        $this->_process();

    } // __construct()


    /**
     *
     * @param       array $typeDefinition
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $typeDefinition
     *
     * @return      void
     *
     * @version     1.2.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(array $typeDefinitions): void
    {
        new ServerGenerator($typeDefinitions);
        new RouteGenerator($typeDefinitions);

    } // process()


} // class JsonApiGenerator extends BaseGenerator {}
