## laravel-code-generator

A package for the dynamic generation of program codes based on migrations or database schemas.

### Installation

As the package is not in a public repository, the repository must be registered in the first installation step:

`composer config repositories.bplan/laravel-code-generator vcs https://git.bplan-solutions.de:3000/bplan/laravel-code-generator.git`

The package can then be installed:

`composer require bplan/laravel-code-generator`


### Configuration

There are various configuration options that can be set via the “.env” configuration file.


`CODE_GENERATOR_ACTIVE    bool`

Automatic code generation is deactivated by default.


`CODE_GENERATOR_AUTHOR    string`

The character string that is used for the placeholder `{{ author }}` in the comment blocks. The common format for this string is `firstname lastname <name@example.com>`.


`CODE_GENERATOR_COPYRIGHT    string`

The character string that is used for the placeholder `{{ copyright }}` in the comment blocks. The common format for this string is `firstname lastname, company <http://www.company-name.com/>`.


`CODE_GENERATOR_CREATE_CSHARP    bool`

Deactivates/activates the creation of classes for C#. There is currently only one generator for NewtonSoft classes. The generated classes are stored in the directory `storage/app/build/CodeGenerator/CSharp/NewtonSoft`.


`CODE_GENERATOR_CREATE_JSONAPI    bool`

Deactivates/activates the creation of classes and route files for the package `laravel-json-api/laravel`. The files are stored under `storage/app/build/CodeGenerator/JsonApi` and also directly in the directory structure of the Laravel project.


`CODE_GENERATOR_CREATE_LARAVEL    bool`

Deactivates/activates the creation of regular Laravel classes. The files are stored under `storage/app/build/CodeGenerator/Laravel` and also directly in the directory structure of the Laravel project.


`CODE_GENERATOR_DEV_START    integer (year)`

Specifies the start year of the project's development. This value is used to display the development period of the project in the copyright comment of the generated files. If there is no configuration for this value, the current year is always used.


`CODE_GENERATOR_PROJECT_NAME    string`

The name of the project to be inserted in the DocBlocks with the tag `@package`. If this configuration setting is not available, the value of `APP_NAME` is used. If this configuration option is also not available or empty, then `CodeGenerator` is used.


### Publishing

The following command can be used to publish the configuration file:

`php artisan vendor:publish --provider="Bplan\LaravelCodeGenerator\PackageServiceProvider" --tag=config`

Normally, the CodeGenerator should always be configured via the ".env" file so that it is not necessary to publish the configuration file.


The following command publishes the starter class for the CodeGenerator to `app/Generators/CodeGenerator.php`.

`php artisan vendor:publish --provider="Bplan\LaravelCodeGenerator\PackageServiceProvider" --tag=class`

It is recommended to always use this starter class and not directly the actual CodeGenerator class from the package. The starter class must be included in the version management.


### Usage

```
use App\Generators\CodeGenerator;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('users', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamps();

            $Table->foreignId('current_team_id')->nullable();
            $Table->string('email')->unique();
            $Table->timestamp('email_verified_at')->nullable();
            $Table->string('name');
            $Table->string('password');
            $Table->string('profile_photo_path', 2048)->nullable();
            $Table->rememberToken();

            **new CodeGenerator($Table);**
        });
    }
}
```



