<?php
/**
 * Code Generator Definition Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Definitions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Definitions;


use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Schema\ForeignKeyDefinition as SchemaForeignKeyDefinition;
use Illuminate\Support\Fluent;
use Illuminate\Support\Str;


use Bplan\LaravelCodeGenerator\Definitions\ForeignKeyDefinition;
use Bplan\LaravelCodeGenerator\Enums\Generator;
use Bplan\LaravelCodeGenerator\Enums\ModelType;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;


/**
 * Code Generator Definition Class
 *
 * @version     5.0.0 / 2024-12-30
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class TypeDefinition
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_additionalRelations
     */
    private $_additionalRelations;


    /**
     * @var     array $_appends
     */
    private $_appends;


    /**
     * @var     array $_columns
     */
    private $_columns = [];


    /**
     * @var     array $_excludes
     */
    private $_excludes = [];


    /**
     * @var     array $_fieldDefinitions
     */
    private $_fieldDefinitions = [];


    /**
     * @var     array $_foreignKeys
     */
    private $_foreignKeys = [];


    /**
     *
     * @var     string $_modelType
     */
    private $_modelType = ModelType::Model->name;


    /**
     * @var     array $_package
     */
    private $_package;


    /**
     * @var     array $_pivotTables
     */
    private $_pivotTables = [];


    /**
     * @var     array $_routing
     */
    private $_routing;


    /**
     *
     * @var     string $_tableName
     */
    private $_tableName;


    /**
     *
     * @var     string $_tablePrefix
     */
    private $_tablePrefix;


    /**
     * @var     array $_traits
     */
    private $_traits = [];


    /**
     *
     * @var     string $_typeName
     */
    private $_typeName;


    /**
     * @var     array $_uses
     */
    private $_uses = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_possibleExcludes
     */
    private static $_possibleExcludes = [
        Generator::LaravelActionCreate->value,
        Generator::LaravelActionDelete->value,
        Generator::LaravelActionUpdate->value,
    ];


    /**
     * @var     array $_fieldDefintions
     */
    private static $_fieldDefintions = [];


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Blueprint $Blueprint
     *
     * @param       array $additionalSettings
     *
     * @return      void
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Blueprint $Blueprint, array $additionalSettings = [])
    {
        $this->_process($Blueprint, $additionalSettings);

        // $this->_writeCache();

    } // __construct()


    /**
     *
     * @param       array|null $additionalColumnSettings
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _createFieldDefinitions(array|null $additionalColumnSettings): self
    {
        self::$_fieldDefintions[$this->_tableName] = [];

        foreach ($this->_columns as $columnName => $columnDefinition) {
            $FieldDefinition = new FieldDefinition($columnDefinition, $additionalColumnSettings[$columnName] ?? null);

            $this->_fieldDefinitions[$columnName] = $FieldDefinition;
            self::$_fieldDefintions[$this->_tableName][$columnName] = $FieldDefinition;
        }
        return $this;

    } // _createFieldDefinitions()


    /**
     *
     * @param       array $excludes
     *
     * @param       array & $additionalSettings
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareExcludes(array $excludes, array & $additionalSettings): self
    {
        foreach ($excludes as $exclude) {
            if (!in_array($exclude, self::$_possibleExcludes)) {
                continue;
            }
            $this->_excludes[$exclude] = $exclude;
        }
        if (isset($this->_excludes[Generator::LaravelActionCreate->value])
         && isset($this->_excludes[Generator::LaravelActionDelete->value])
         && isset($this->_excludes[Generator::LaravelActionUpdate->value])) {
            $this->_excludes[Generator::LaravelService->value] = Generator::LaravelService->value;

            if (!isset($additionalSettings['routing'])) {
                $additionalSettings['routing'] = [];
            }
            foreach (config('code-generator.jsonapi-servers') as $server => $status) {
                if ($status === false) {
                    continue;
                }
                $server = strtolower($server);

                $additionalSettings['routing'][$server] = 'readOnly';
            }
        } elseif (isset($this->_excludes[Generator::LaravelActionCreate->value])
          || isset($this->_excludes[Generator::LaravelActionDelete->value])
          || isset($this->_excludes[Generator::LaravelActionUpdate->value])) {
            $actions = [];

            if (!isset($additionalSettings['routing'])) {
                $additionalSettings['routing'] = [];
            }
            foreach (config('code-generator.jsonapi-servers') as $server => $status) {
                $server = strtolower($server);
                /*
                **  Wenn eh nur die Lese- oder Relationen-Routen implementiert werden sollen, dann kann
                **  der aktuelle Schleifendurchlauf gleich abgebrochen werden. */
                if (isset($additionalSettings['routing'][$server])
                  && ($additionalSettings['routing'][$server] === false
                   || $additionalSettings['routing'][$server] === 'readOnly'
                   || $additionalSettings['routing'][$server] === 'relationsOnly')) {
                    continue;
                }
                if (!isset($additionalSettings['routing'][$server])) {
                    $additionalSettings['routing'][$server] = [
                        'actions' => [],
                        'method' => 'except',
                    ];
                } else {
                    if (!isset($additionalSettings['routing'][$server]['actions'])) {
                        $additionalSettings['routing'][$server]['actions'] = [];
                    }
                    if (!isset($additionalSettings['routing'][$server]['method'])) {
                        $additionalSettings['routing'][$server]['method'] = 'except';

                    } elseif ($additionalSettings['routing'][$server]['method'] !== 'except') {
                        $additionalSettings['routing'][$server]['actions'] = [];
                        $additionalSettings['routing'][$server]['method'] = 'except';
                    }
                }
                foreach (self::$_possibleExcludes as $exclude) {
                    if (!isset($this->_excludes[$exclude])) {
                        continue;
                    }
                    switch ($exclude) {
                        case Generator::LaravelActionCreate->value:
                            $additionalSettings['routing'][$server]['actions'][] = 'store';
                            break;

                        case Generator::LaravelActionDelete->value:
                            $additionalSettings['routing'][$server]['actions'][] = 'destroy';
                            break;

                        case Generator::LaravelActionUpdate->value:
                            $additionalSettings['routing'][$server]['actions'][] = 'update';
                            break;
                    }
                }
            }
        }
        return $this;

    } // _prepareExcludes()


    /**
     *
     * @param       Blueprint $Blueprint
     *
     * @param       array $additionalSettings
     *
     * @return      $this
     *
     * @version     1.6.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _process(Blueprint $Blueprint, array $additionalSettings = []): self
    {
        $this->_tableName = $Blueprint->getTable();
        $this->_tablePrefix = $Blueprint->getPrefix();

        if (isset($additionalSettings['typeName'])) {
            $this->_typeName = $additionalSettings['typeName'];
        } else {
            $this->_typeName = $this->_tableName;
        }
        if (isset($additionalSettings['pivotTables'])) {
            $this->_pivotTables = array_combine($additionalSettings['pivotTables'], array_reverse($additionalSettings['pivotTables']));

            $this->_modelType = ModelType::Pivot->name;
        }
        if (isset($additionalSettings['exclude'])) {
            $this->_prepareExcludes($additionalSettings['exclude'], $additionalSettings);
        }
        if (isset($additionalSettings['package'])) {
            if (is_array($additionalSettings['package'])) {
                $this->_package = $additionalSettings['package'];

            } else {
                list($vendorName, $packageName) = explode('/', $additionalSettings['package']);

                $this->_package = [
                    'name' => $additionalSettings['package'],
                    'namespace' => Str::studly($vendorName).'\\'.Str::studly($packageName),
                ];
            }
        }
        $this->_additionalRelations = $additionalSettings['additionalRelations'] ?? [];
        $this->_routing = $additionalSettings['routing'] ?? null;
        $this->_traits = $additionalSettings['traits'] ?? null;
        $this->_uses = $additionalSettings['uses'] ?? null;

        $this->_processAppends($additionalSettings['appends'] ?? null);
        $this->_processColumns($Blueprint->getColumns());
        /*
        **  Commands abarbeiten und FeldDefinitionen ergänzen. */
        $this->_processCommands($Blueprint->getCommands(), $additionalSettings['columns'] ?? null);
        /*
        **  FieldDefinition-Objekte erzeugen. */
        $this->_createFieldDefinitions($additionalSettings['columns'] ?? null);

        return $this;

    } // _process()


    /**
     * Bereitet die Werte der appends-Option auf
     *
     * @param       array|null $appends
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAppends(array|null $appends): self
    {
        $this->_appends = [];

        if ($appends === null) {
            return $this;
        }
        /*
        **  [
        **      'label' => [
        **          'generate' => CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_MODEL_ARRAY + CodeGenerator::APPENDS_MODEL_METHOD,
        **          'return' => '$this->last_name.\', \'.$this->first_name',
        **      ]
        **  ]
        */
        foreach ($appends as $key => $value) {
            $field = $key;

            if (is_array($value)) {
                $generate = isset($value['generate'])
                    ? (int) $value['generate']
                    : CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_LARAVEL_MODEL_ARRAY + CodeGenerator::APPENDS_LARAVEL_MODEL_METHOD;

                $return = isset($value['return']) ? $value['return'] : 'null;';

            } else {
                if (is_numeric($value)) {
                    /*
                    **  [
                    **      'profile_photo_url' => CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_MODEL_ARRAY,
                    **  ]
                    */
                    $generate = $value;

                } else {
                    $generate = CodeGenerator::APPENDS_JSONAPI_SCHEMA + CodeGenerator::APPENDS_LARAVEL_MODEL_ARRAY + CodeGenerator::APPENDS_LARAVEL_MODEL_METHOD;
                }
                $return = 'null;';
            }
            $generators = [];

            if ($generate & CodeGenerator::APPENDS_JSONAPI_SCHEMA) {
                $generators[Generator::JsonApiSchema->value] = true;
            }
            if ($generate & CodeGenerator::APPENDS_LARAVEL_MODEL_ARRAY) {
                $generators[Generator::LaravelModel->value.'.array'] = true;
            }
            if ($generate & CodeGenerator::APPENDS_LARAVEL_MODEL_METHOD) {
                $generators[Generator::LaravelModel->value.'.method'] = true;
            }
            if (substr($return, -1) !== ';') {
                $return .= ';';
            }
            $this->_appends[$field] = [
                'field' => $field,
                'generate' => $generate,
                'generators' => $generators,
                'return' => $return,
            ];
        }
        return $this;

    } // _processAppends()


    /**
     * Verarbeitet alle Spalten und erstellt einen assoziativen Array mit den Spaltennamen als Schlüssel
     *
     * @param       array $columns
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processColumns(array $columns): self
    {
        foreach ($columns as $Column) {
            $column = $Column->toArray();
            $columnName = $column['name'];

            $column['isForeignKey'] = false;

            ksort($column);

            $this->_columns[$columnName] = $column;
        }
        return $this;

    } // _processColumns()


    /**
     * Verarbeitet Commands und ergänzt die Column-Definitionen in $_fieldDefinitions
     *
     * In den Commands des Blueprint-Objekts sind unter anderem die ForeignKey-Definitionen enthalten.
     *
     * @param       array $commands
     *
     * @param       array|null $additionalColumnSetting
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processCommands(array $commands, array|null $additionalColumnSetting): self
    {
        foreach ($commands as $Command) {
            $attributes = $Command->getAttributes();

            if ($Command instanceof SchemaForeignKeyDefinition) {
                $columnName = $attributes['columns'][0];

                $attributes['relationType'] = 'BelongsTo';

                ksort($attributes);

                $this->_columns[$columnName]['isForeignKey'] = true;
                $this->_columns[$columnName]['ForeignKeyDefinition'] = new ForeignKeyDefinition($attributes);
                $this->_columns[$columnName]['reverseRelationName'] = null;

                $this->_foreignKeys[$columnName] = $this->_columns[$columnName];

                if (isset($additionalColumnSetting[$columnName]['reverseRelationName'])) {
                    $this->_foreignKeys[$columnName]['reverseRelationName'] = $additionalColumnSetting[$columnName]['reverseRelationName'];
                }
                ksort($this->_foreignKeys[$columnName]);

                continue;

            } elseif ($Command instanceof Fluent) {
                if ($attributes['name'] === 'create') {
                    continue;
                }
                /*
                    Index-Informationen werden aktuell noch nicht berücksichtigt, könnten aber insbesondere
                    für die Rules relevant werden um zum Beispiel eine unique-Rule zu erzeugen.

                */
                //self::$_collectedIndexes[$this->_tableName][] = $attributes;
            }
        }
        return $this;

    } // _processCommands()


    /**
     *
     * @param       string $tableName
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAdditionalRelations(): array
    {
        return $this->_additionalRelations;

    } // getAdditionalRelations()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAppends(): array
    {
        return $this->_appends;

    } // getAppends()


    /**
     *
     * @param       string $tableName
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getFieldDefinitions(string $tableName): array
    {
        return self::$_fieldDefintions[$tableName];

    } // getFieldDefinitions()


    /**
     *
     * @param       string $columnName
     *
     * @return 	    array|null
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getForeignKey(string $columnName): array|null
    {
        if (!isset($this->_foreignKeys[$columnName])) {
            return null;
        }
        return $this->_foreignKeys[$columnName];

    } // getForeignKey()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getForeignKeys(): array
    {
        return $this->_foreignKeys;

    } // getForeignKeys()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPivotTables(): array
    {
        return $this->_pivotTables;

    } // getPivotTables()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getModelType(): string
    {
        return $this->_modelType;

    } // getModelType()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPackageName(): null|string
    {
        return $this->_package['name'] ?? null;

    } // getPackageName()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPackageNamespace(): null|string
    {
        return $this->_package['namespace'] ?? null;

    } // getPackageNamespace()


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRouting()
    {
        return $this->_routing;

    } // getRouting()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getTableName(): string
    {
        return $this->_tableName;

    } // getTableName()


    /**
     *
     * @param       string $traitsFor
     *
     * @return 	    array|null
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getTraits(string $traitsFor): array|null
    {
        if (empty($this->_traits[$traitsFor])) {
            return null;
        }
        return $this->_traits[$traitsFor];

    } // getTraits()


    /**
     *
     * @param       string $caseStyle
     *
     * @param       bool|null $singular
     *
     * @return 	    string
     *
     * @version     3.0.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getTypeName(null|string $caseStyle, bool|null $singular = null): string
    {
        $typeName = $this->_typeName;

        if ($singular === true) {
            $typeName = Str::singular($this->_typeName);

        } elseif ($singular === false) {
            $typeName = Str::plural($this->_typeName);
        }
        switch ($caseStyle) {
            case 'camel':
                return Str::camel($typeName);
                break;

            case 'slug':
                return Str::slug(Str::snake($typeName));
                break;

            case 'snake':
                return Str::snake($typeName);
                break;

            case 'studly':
                return Str::studly($typeName);
                break;

            default:
                return $typeName;
        }
    } // getTypeName()


    /**
     *
     * @param       string $usesFor
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getUses(string $usesFor): array|null
    {
        if (empty($this->_uses[$usesFor])) {
            return null;
        }
        return $this->_uses[$usesFor];

    } // getUses()


    /**
     *
     * @param       Generator|string $generator
     *
     * @return 	    bool
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function hasExclude(Generator|string $generator): bool
    {
        if ($generator instanceof Generator) {
            $generator = $generator->value;
        }
        return isset($this->_excludes[$generator]);

    } // hasExclude()


    /**
     *
     * @return 	    bool
     *
     * @version     1.0.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function isForPackage(): bool
    {
        return !empty($this->_package);

    } // isForPackage()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function writeCacheFile(): self
    {
        $cachePath = CodeGenerator::getCachePath();

        ksort($this->_fieldDefinitions);

        unset($this->_columns);

        file_put_contents($cachePath.'/'.$this->_tableName.'.php', '<?php'."\n\n".'return '.var_export($this, true).';'."\n");

        return $this;

    } // writeCacheFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class TypeDefinition {}
