<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @todo        UserSchema          currentTeamId
 *
 * @todo        Methode _processAdditionalRelations()   >   Relationentyp prüfen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi;


use Bplan\LaravelCodeGenerator\Definitions\FieldDefinition;
use Bplan\LaravelCodeGenerator\Enums\Generator;
use Bplan\LaravelCodeGenerator\Enums\ModelType;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;
use Illuminate\Support\Str;


/**
 * JasonApi Code Generator Class
 *
 * @version     5.0.0 / 2024-12-30
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SchemaGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_appends
     */
    protected $_appends = [];


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir = 'app';


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     string $_idField
     */
    private $_idField;


    /**
     * @var     array $_regularFields
     */
    private $_regularFields = [];


    /**
     * @var     array $_relationFields
     */
    private $_relationFields = [];


    /**
     * @var     array $_technicalFields
     */
    private $_technicalFields = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiSchema->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $methodName
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addRelation(string $name, string $type, string $resourceName): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Multiple relations ['.$type.' '.$name.']');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] =
                $this->_relationFields[$key];
            }
            $this->_errors[$key][] = [
                'name' => $name,
                'resourceName' => $resourceName,
                'type' => $type,
            ];
            $key .= '-failure';
            $name .= '-failure';

        }
        $this->_relationFields[$key] = [
            'name' => $name,
            'resourceName' => $resourceName,
            'type' => $type,
        ];
        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    string
     *
     * @version     1.3.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/schema.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('fields', $this->_prepareFieldReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $configNamespace = config('jsonapi.namespace', config('code-generator.jsonapi-namespace', 'JsonApi'));

        $modelNamespace = 'App\\Models';

        $this->_namespace = 'App\\'.$configNamespace;

        if ($this->_TypeDefinition->isForPackage()) {
            $packageNamespace = $this->_TypeDefinition->getPackageNamespace();
            $modelNamespace = $packageNamespace.'\\Models';

            $this->_baseDir = 'src';
            $this->_namespace = $packageNamespace.'\\'.$configNamespace;
            $this->_package = $this->_TypeDefinition->getPackageName();
        }
        $this->_addUse($modelNamespace.'\\'.$this->_typeName);

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            'LaravelJsonApi\\Eloquent\\Contracts\\Paginator',
            'LaravelJsonApi\\Eloquent\\Filters\\WhereIdIn',
            'LaravelJsonApi\\Eloquent\\Pagination\\PagePagination',
            'LaravelJsonApi\\Eloquent\\Schema',
        ]);
        return parent::_initUses();

    } // _initUses()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.4.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareFieldReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Felddefinitionen zusammenstellen. */
        $padding = str_repeat(' ', 12);
        $replacement = '';

        if ($this->_idField !== null) {
            $replacement .= "\n".$padding.$this->_idField;
        }
        if (!empty($this->_technicalFields)) {
            ksort($this->_technicalFields);

            $replacement .= "\n";

            foreach ($this->_technicalFields as $field) {
                $replacement .= "\n".$padding.$field;
            }
        }
        if (!empty($this->_regularFields)) {
            ksort($this->_regularFields);

            $replacement .= "\n";

            foreach ($this->_regularFields as $key => $field) {
                $replacement .= "\n".$padding.$field;
            }
        }
        if (!empty($this->_appends)) {
            $replacement .= "\n".$padding.'/*'
                ."\n".$padding.'**  Appended fields */';

            foreach ($this->_appends as $appendField) {
                $replacement .= "\n".$padding.$appendField;
            }
        }
        if (!empty($this->_relationFields)) {
            /*
            **  Relationen-Felder abarbeiten. */
            ksort($this->_relationFields);

            $replacement .= "\n".$padding.'/*'
                ."\n".$padding.'**  Relations */';

            foreach ($this->_relationFields as $relation) {
                $replacement .= "\n".$padding.$relation['type'].'::make(\''.$relation['name'].'\')->type(\''.$relation['resourceName'].'\')->serializeUsing('
                    ."\n".$padding.'    static fn($Relation) => $Relation->alwaysShowData()'
                    ."\n".$padding.'),';
            }
        }
        $replacement .= "\n";

        return $replacement;

    } // _prepareFieldReplacement()


    /**
     *
     * @param       FieldDefinition $FieldDefinition
     *
     * @return 	    string
     *
     * @version     2.2.0 / 2024-11-14
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareRegularField(FieldDefinition $FieldDefinition): string
    {
        $columnName = $FieldDefinition->getName();
        $nameCamelCase = $FieldDefinition->getName('camel');

        switch ($FieldDefinition->getAttribute('abstractType')) {
            case 'bool':
                $field = 'Boolean::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Boolean');
                break;

            case 'datetime':
                /*
                **  Sonderbehandlung für die Felder "created_at", "deleted_at" und "updated_at".
                **  Diese Felder sind automatisch "readOnly" und "sortable", sofern in der Migration keine
                **  abweichende Einstellung vorgenommen wurde. */
                if (FieldDefinition::isTechnicalField($columnName)) {
                    $FieldDefinition->setAttribute('hidden', $FieldDefinition->getAttribute('hidden') ?? true);
                    $FieldDefinition->setAttribute('readOnly', $FieldDefinition->getAttribute('readOnly') ?? true);
                    $FieldDefinition->setAttribute('sortable', $FieldDefinition->getAttribute('sortable') ?? true);
                }
                $field = 'DateTime::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\DateTime');
                break;

            case 'string':
                if ($FieldDefinition->getAttribute('type') === 'json') {
                    $jsonType = 'Array'.($FieldDefinition->getAttribute('jsonType') ?? CodeGenerator::JSON_TYPE_ARRAY);

                    $field = $jsonType.'::make(\''.$nameCamelCase.'\')';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\'.$jsonType);

                } else {
                    $field = 'Str::make(\''.$nameCamelCase.'\')';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
                }
                break;

            case 'integer':
                $field = 'Number::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Number');
                break;

            default:
                $field = 'Str::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
        }
        if ($FieldDefinition->getAttribute('hidden') === true) {
            $field .= '->hidden()';
        }
        if ($FieldDefinition->getAttribute('readOnly') === true) {
            $field .= '->readOnly()';
        }
        if ($FieldDefinition->getAttribute('sortable') === true) {
            $field .= '->sortable()';
        }
        $field .= ',';

        return $field;

    } // _prepareRegularField()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinition();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_TypeDefinition->getAdditionalRelations() as $additionalRelation) {
            $relationName = $additionalRelation['relationName'];
            $relationType = $additionalRelation['relationType'];
            $resourceName = $additionalRelation['resourceName'];
// @todo    Relationentyp prüfen
            if ($relationType === 'HasManyThrough') {
                $relationType = 'HasMany';
            }
            $this->_addRelation($relationName, $relationType, $resourceName);

            $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAppendFields(): self
    {
        $appends = $this->_TypeDefinition->getAppends();

        if (!empty($appends)) {
            ksort($appends);
            /*
            **  Ersetzungs-String für die Attribute-Methoden zusammenstellen. */
            foreach ($appends as $append) {
                $generator = self::$_generator;

                if (!isset($append['generators'][$generator])) {
                    continue;
                }
                $field = Str::camel($append['field']);
                /*
                **  Appends-Felder werden der Einfahheit halber immer als String-Felder angelegt. Bisher gab es
                **  noch keinen Grund die Felder spezieller zu definieren. */
                $this->_appends[] = 'Str::make(\''.$field.'\'),';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
            }
        }
        return $this;

    } // _processAppendFields()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getColumnName();
                $relatedTable = $BackReference->getTableName();

                $RelatedTypeDefinition = CodeGenerator::getTypeDefinition($relatedTable);

                $pivotTables = $RelatedTypeDefinition->getPivotTables();
                /*
                **  ForeignId-Felder haben nicht zwingend eine Constraint (siehe users.current_team_id). Aus dem
                **  Grund muss hier überprüft werden ob es eine entsprechende Definition gibt. */
                if ($BackReference->getModelType() === ModelType::Pivot->name && isset($pivotTables[$this->_tableName])) {
                    $TypeDefinition = CodeGenerator::getTypeDefinition($pivotTables[$this->_tableName]);





                    // $relationName = Str::slug($pivotTables[$this->_tableName]);
                    // $resourceName = str::plural($BackReference->getTableName('slug'));
                    $relationType = 'BelongsToMany';
// dump($rsourceName);
                } else {
                    $TypeDefinition = CodeGenerator::getTypeDefinition($BackReference->getTableName());






                    // $foreignKey = $RelatedTypeDefinition->getForeignKey($columnName);
                    // $resourceName = $BackReference->getTableName('slug');

                    // if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    //     $relationName = $foreignKey['reverseRelationName'];
                    // } else {
                    //     $relationName = $resourceName;
                    // }
                    $relationType = 'HasMany';
                }
                $foreignKey = $RelatedTypeDefinition->getForeignKey($columnName);
                //$resourceName = str::plural($BackReference->getTableName('slug'));


                $resourceName = $TypeDefinition->getTypeName('slug', singular: false);
// dump($resourceName, '-----');
                if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    $relationName = $foreignKey['reverseRelationName'];
                } else {
                    $relationName = $resourceName;
                }








                $this->_addRelation($relationName, $relationType, $resourceName);
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processTypeDefinition(): self
    {
        /*
        **  Felddefinitionen zusammenstellen. */
        foreach ($this->_FieldDefinitions as $FieldDefinition) {
            $columnName = $FieldDefinition->getName('snake');
            $nameCamelCase = $FieldDefinition->getName('camel');
            /*
                todo    Sonderfall berücksichtigen:
                        Der Primary-Key id kann unter Umständen kein AutoIncrement sein, wenn er
                        ein Foreign-Key auf eine andere Tabelle ist.
            */
            if ($FieldDefinition->getAttribute('autoIncrement') === true) {
                if ($columnName === 'id') {
                    $this->_idField = 'ID::make(),';
                } else {
                    $this->_idField = 'ID::make(\''.$nameCamelCase.'\')';
                }
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\ID');

                continue;
            }
            /*
            **  Foreign-Keys abarbeiten. */
            if ($FieldDefinition->isForeignKey() === true) {
                $ForeignKeyDefinition = $FieldDefinition->getForeignKeyDefinition();

                if ($ForeignKeyDefinition === null) {
                    continue;
                }
                $relationName = $ForeignKeyDefinition->getRelationName();   // ok
                $resourceName = $ForeignKeyDefinition->getResourceName();

                $this->_addRelation($relationName, 'BelongsTo', $resourceName);
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\BelongsTo');

                continue;
            }
            $field = $this->_prepareRegularField($FieldDefinition);

            if (FieldDefinition::isTechnicalField($columnName)) {
                $this->_technicalFields[$nameCamelCase] = $field;

                continue;
            }
            $this->_regularFields[strtolower($nameCamelCase)] = $field;
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_processAppendFields();
        $this->_initUses();

        return $this;

    } // _processTypeDefinition()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Schema-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach (config('code-generator.jsonapi-servers') as $server => $status) {
            if ($status === false) {
                continue;
            }
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $fileContents = parent::replacePlaceholder('namespace-addition', $server.'\\'.$this->_typeNamePlural, $baseFileContents);
            /*
            **  Schema-Klasse schreiben. */
            $this->_filePath = 'JsonApi/'.$server.'/'.$this->_typeNamePlural;

            parent::_writeFileContents($this->_typeName.'Schema.php', $fileContents);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SchemaGenerator extends JsonApiFileGenerator {}
