<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi;


use Bplan\LaravelCodeGenerator\Enums\Generator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\BaseGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApiGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     3.0.0 / 2025-01-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ServerGenerator extends JsonApiGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     array $_baseNamespaces
     */
    private $_baseNamespaces = [];


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     string $_packageName
     */
    private $_packageName;


    /**
     * @var     array $_packages
     */
    private $_packages = [];


    /**
     * @var     array $_schemaClasses
     */
    private $_schemaClasses = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiServer->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $package
     *
     * @return 	    string
     *
     * @version     2.1.0 / 2025-01-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(string $package): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/server.stub');

        if ($package !== '.project') {
            $fileContents = parent::replacePlaceholder('package', $package, $fileContents);
        }
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('schema-classes', $this->_prepareSchemaReplacement($package), $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-01-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_addUse('Illuminate\\Support\\Facades\\Auth');
        $this->_addUse('LaravelJsonApi\\Core\\Server\\Server as BaseServer');

        return $this;

    } // _init()


    /**
     *
     * @param       string $package
     *
     * @return 	    string
     *
     * @version     2.0.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareSchemaReplacement(string $package): string
    {
        ksort($this->_schemaClasses[$package]);

        $padding = str_repeat(' ', 12);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_schemaClasses[$package] as $schemaClass) {
            $replacement .= "\n".$padding.$schemaClass.',';
        }
        return $replacement;

    } // _prepareSchemaReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypeDefinitions();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processTypeDefinitions(): self
    {
        foreach ($this->_typeDefinitions as $TypeDefinition) {
            $typeName = $TypeDefinition->getTypeName('studly', singular: true);
            $typeNamePlural = $TypeDefinition->getTypeName('studly', singular: false);

            $this->_packageName = $TypeDefinition->getPackageName() ?? '.project';

            $this->_baseNamespaces[$this->_packageName] = $TypeDefinition->getPackageNamespace();
            $this->_packages[$this->_packageName] = $this->_packageName;
            $this->_schemaClasses[$this->_packageName][strtolower($typeName)] = $typeNamePlural.'\\'.$typeName.'Schema::class';
        }
        return $this;

    } // _processTypeDefinitions()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        /*
        **  Pakete abarbeiten. */
        foreach ($this->_packages as $package) {
            $baseFileContents = $this->_getPreparedFileContents($package);
            /*
            **  Server-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
            foreach (config('code-generator.jsonapi-servers') as $server => $status) {
                if ($status === false) {
                    continue;
                }
                $fileContents = parent::replacePlaceholder('lower-server', strtolower($server), $baseFileContents);

                if ($package === '.project') {
                    $fileContents = parent::replacePlaceholder('namespace', 'App\\JsonApi\\'.$server, $fileContents);
                    $packageParam = null;

                    $this->_baseDir = 'app';

                } else {
                    $fileContents = parent::replacePlaceholder('namespace', $this->_baseNamespaces[$package].'\\JsonApi\\'.$server, $fileContents);
                    $packageParam = $package;

                    $this->_baseDir = 'src';
                }
                /*
                **  Server-Klasse schreiben. */
                $this->_filePath = 'JsonApi/'.$server;

                parent::_writeFileContents('Server.php', $fileContents, $packageParam);
            }
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ServerGenerator extends JsonApiGenerator {}
