<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelCodeGenerator\Generators\CodeGenerator;

use Bplan\LaravelCodeGenerator\Definitions\TypeDefinition;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi\PolicyGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi\RequestGenerator;
use Bplan\LaravelCodeGenerator\Generators\CodeGenerator\JsonApi\SchemaGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     2.2.0 / 2024-11-01
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class JsonApiFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @version     2.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(TypeDefinition $TypeDefinition)
    {
        $this->_stubPath = CodeGenerator::getStubPath('jsonapi');

        parent::__construct($TypeDefinition);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @return      void
     *
     * @version     3.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(TypeDefinition $TypeDefinition): void
    {
        new SchemaGenerator($TypeDefinition);
        new RequestGenerator($TypeDefinition);
        new PolicyGenerator($TypeDefinition);

    } // process()


} // class JsonApiFileGenerator extends BaseFileGenerator {}
