<?php
/**
 * Code Generator Definition Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Definitions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Definitions;


use Illuminate\Support\Str;


/**
 * Code Generator Definition Class
 *
 * @version     1.2.0 / 2024-10-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BackReference
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    // use DefinitionAttributes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_columnName
     */
    private $_columnName;


    /**
     * @var     string $_modelType
     */
    private $_modelType;


    /**
     * @var     string $_tableName
     */
    private $_tableName;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $modelType
     *
     * @param       string $tableName
     *
     * @param       string $columnName
     *
     * @version     1.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $modelType, string $tableName, string $columnName)
    {
        $this->_modelType = $modelType;
        $this->_tableName = $tableName;
        $this->_columnName = $columnName;

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getColumnName(): string
    {
        return $this->_columnName;

    } // getColumnName()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getModelType(): string
    {
        return $this->_modelType;

    } // getModelType()


    /**
     *
     * @param       string $caseStyle
     *
     * @param       bool $singular
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getTableName(string $caseStyle = null, bool $singular = false): string
    {
        $tableName = $this->_tableName;

        if ($singular === true) {
            $tableName = Str::singular($tableName);
        }
        switch ($caseStyle) {
            case 'camel':
                return Str::camel($tableName);
                break;

            case 'slug':
                return Str::slug($tableName);
                break;

            case 'studly':
                return Str::studly($tableName);
                break;

            default:
                return $tableName;
        }

    } // getTableName()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BackReference {}
