<?php
/**
 * Code Generator Definition Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Definitions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Definitions;


use Illuminate\Support\Str;


/**
 * Code Generator Definition Class
 *
 * @version     2.0.0 / 2025-02-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Package
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_baseDir
     */
    private $_baseDir = 'src';


    /**
     * @var     string $_name
     */
    private $_name;


    /**
     * @var     string $_namespace
     */
    private $_namespace;


    /**
     * @var     string $_prefix
     */
    private $_prefix;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array|string $settings
     *
     * @version     1.1.0 / 2025-02-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array|string $settings)
    {
        if (is_array($settings)) {
            $this->_name = $settings['name'];

            if (isset($settings['baseDir'])) {
                $this->_baseDir = $settings['baseDir'];
            }
            if (isset($settings['namespace'])) {
                $this->_namespace = $settings['namespace'];

            } else {
                list($vendorName, $packageName) = explode('/', $this->_name);

                $this->_namespace = Str::studly($vendorName).'\\'.Str::studly($packageName);
            }
            if (isset($settings['prefix'])) {
                $this->_prefix = strtolower($settings['prefix']);
            }
        } else {
            list($vendorName, $packageName) = explode('/', $settings);

            $this->_name = $settings;
            $this->_namespace = Str::studly($vendorName).'\\'.Str::studly($packageName);
        }
    } // __construct()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2025-02-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getBaseDir(): null|string
    {
        return $this->_baseDir;

    } // getBaseDir()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2025-02-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getName(): null|string
    {
        return $this->_name;

    } // getName()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2025-02-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getNamespace(): null|string
    {
        return $this->_namespace;

    } // getNamespace()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2025-02-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPrefix(): null|string
    {
        return $this->_prefix;

    } // getPrefix()


    /**
     *
     * @return 	    null|string
     *
     * @version     1.0.0 / 2025-02-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPreparedTypeName(string $typeName): null|string
    {
        if ($this->_prefix !== null) {
            return Str::studly($this->_prefix).$typeName;
        }
        return $typeName;

    } // getPreparedTypeName()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Package {}
