<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Definitions\TypeDefinition;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\PolicyGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\RequestGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\SchemaGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     3.1.0 / 2025-02-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class JsonApiFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_jsonApiNameSpace
     */
    protected $_jsonApiNameSpace;


    /**
     * @var     array $_jsonApiServers
     */
    protected $_jsonApiServers;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @version     2.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(TypeDefinition $TypeDefinition)
    {
        $this->_stubPath = CodeGenerator::getStubPath('jsonapi');

        parent::__construct($TypeDefinition);

    } // __construct()


    /**
     *
     * @param       array $typeDefinition
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-02-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_jsonApiNameSpace = config('jsonapi.namespace', 'JsonApi');
        $this->_jsonApiServers = config('code-generator.jsonapi-servers');

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @return      void
     *
     * @version     3.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(TypeDefinition $TypeDefinition): void
    {
        new SchemaGenerator($TypeDefinition);
        new RequestGenerator($TypeDefinition);
        new PolicyGenerator($TypeDefinition);

    } // process()


} // class JsonApiFileGenerator extends BaseFileGenerator {}
