<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     1.0.0 / 2025-02-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseControllerGenerator extends LaravelGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Http/Controllers';


    /**
     * @var     array $_packages
     */
    protected $_packages = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelBaseController->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();
        /*
            Aus den TypeDefinitions das Projekt und die Packages ermitteln
        */
        foreach ($this->_typeDefinitions as $TypeDefinition) {
            if ($TypeDefinition->isForPackage()) {
                $Package = $TypeDefinition->getPackage();

                $packageName = $Package->getName();

                if (isset($this->_packages[$packageName])) {
                    continue;
                }
                $baseDir = $Package->getBaseDir();
                $packageNamespace = $Package->getNamespace().'\\Http\\Controllers';
                $modelNamespace = $packageNamespace.'\\Models';

            } else {
                $packageName = '.project';

                if (isset($this->_packages[$packageName])) {
                    continue;
                }
                $packageName = null;

                $baseDir = 'app';
                $modelNamespace = 'App\\Models';
                $packageNamespace = 'App\\Http\\Controllers';
            }
            $this->_packages[$packageName] = [
                'baseDir' => $baseDir,
                'modeNamespace' => $modelNamespace,
                'name' => $packageName,
                'namespace' => $packageNamespace,
            ];
        }
        return $this;

    } // _init()


    /**
     *
     * @param       array $packageSettings
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-02-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(array $packageSettings): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/base-controller.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('namespace', $packageSettings['namespace'], $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        /*
        **  Pakete abarbeiten. */
        foreach ($this->_packages as $package) {
            $fileContents = $this->_getPreparedFileContents($package);

            $this->_baseDir = $package['baseDir'];
            $this->_package = $package['name'];

            parent::_writeFileContents('Controller.php', $fileContents, $package['name']);
        }
        return $this;
    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BaseControllerGenerator extends LaravelGenerator {}
