<?php
/**
 * Code Generator Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Traits
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Traits;


use Illuminate\Support\Str;


/**
 * Code Generator Trait
 *
 * @version     1.0.0 / 2024-10-20
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
trait DefinitionAttributes
{


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     * @var     array $_attributes
     */
    private $_attributes;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    mixed
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAttribute($attribute): mixed
    {
        if (!isset($this->_attributes[$attribute])) {
            return null;
        }
        return $this->_attributes[$attribute];

    } // getAttribute()


    /**
     *
     * @param       string|null $caseStyle
     *              Steuert die Schreibweise des zurückgegebenen Namen.
     *              Beispiele anhand der Felder "deleted_at" und "main_user_id":
     *
     *                  Parameter       Rückgabe
     *                  camel       >   deletedAt   /   mainUser
     *                  slug        >   deleted-at  /   main-user
     *                  snake       >   deleted_at  /   main_user
     *                  studly      >   DeletedAt   /   MainUser
     *                  column|null >   deleted_at  /   main_user_id
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getName(string|null $caseStyle = null): string
    {
        switch ($caseStyle) {
            case 'camel':
                return $this->_attributes['name'];
                break;

            case 'slug':
                return Str::slug($this->getName('snake'));
                break;

            case 'snake':
                return Str::replaceLast('_id', '', $this->_attributes['columnName']);
                break;

            case 'studly':
                return Str::studly($this->_attributes['name']);
                break;

            case 'column':
            default:
                return $this->_attributes['columnName'];
        }
    } // getName()


} // trait DefinitionAttributes {}
