## laravel-code-generator

A package for the dynamic generation of program codes based on migrations or database schemas.


### Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each package, selected packages are made available via a central repository:

`composer config repositories.bplan/composer-packages composer https://satis.bplan.solutions`

The package can then be installed as a dev-dependency:

`composer require bplan-base/laravel-code-generator --dev`

As the CodeGenerator is installed as a dev dependency, it is also necessary to install the associated loader. This is installed as a regular package and is therefore also available on the production system or if the generator is later uninstalled again. Use the following command to install the loader:

`composer require bplan-base/laravel-code-generator-loader`


### Configuration

There are various configuration options that can be set via the “.env” configuration file.


`CODE_GENERATOR_ACTIVE    bool`

Automatic code generation is deactivated by default.


`CODE_GENERATOR_AUTHOR    string`

The character string that is used for the placeholder `{{ author }}` in the comment blocks. The common format for this string is `firstname lastname <name@example.com>`.


`CODE_GENERATOR_COPYRIGHT    string`

The character string that is used for the placeholder `{{ copyright }}` in the comment blocks. The common format for this string is `firstname lastname, company <http://www.company-name.com/>`.


`CODE_GENERATOR_CREATE_CSHARP    bool`

Deactivates/activates the creation of classes for C#. There is currently only one generator for NewtonSoft classes. The generated classes are stored in the directory `storage/app/build/CodeGenerator/CSharp/NewtonSoft`.


`CODE_GENERATOR_CREATE_JSONAPI    bool`

Deactivates/activates the creation of classes and route files for the package `laravel-json-api/laravel`. The files are stored under `storage/app/build/CodeGenerator/JsonApi` and also directly in the directory structure of the Laravel project.


`CODE_GENERATOR_CREATE_LARAVEL    bool`

Deactivates/activates the creation of regular Laravel classes. The files are stored under `storage/app/build/CodeGenerator/Laravel` and also directly in the directory structure of the Laravel project.


`CODE_GENERATOR_DEV_START    integer (year)`

Specifies the start year of the project's development. This value is used to display the development period of the project in the copyright comment of the generated files. If there is no configuration for this value, the current year is always used.


`CODE_GENERATOR_PROJECT_NAME    string`

The name of the project to be inserted in the DocBlocks with the tag `@package`. If this configuration setting is not available, the value of `APP_NAME` is used. If this configuration option is also not available or empty, then `CodeGenerator` is used.


### Publishing

The following command can be used to publish the configuration file:

`php artisan vendor:publish --provider="BplanBase\CodeGenerator\PackageServiceProvider" --tag=config`

Normally, the CodeGenerator should always be configured via the ".env" file so that it is not necessary to publish the configuration file.


### Usage

```
use BplanBase\CodeGenerator\Generators\CodeGenerator;

return new class extends Migration
{

    public function up(): void
    {
        Schema::create('users', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamps();

            $Table->foreignId('current_team_id')->nullable();
            $Table->string('email')->unique();
            $Table->timestamp('email_verified_at')->nullable();
            $Table->string('name');
            $Table->string('password');
            $Table->string('profile_photo_path', 2048)->nullable();
            $Table->rememberToken();

            __new CodeGenerator($Table);__
        });
    }
}
```



