<?php
/**
 * Code Generator Definition Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Definitions
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Definitions;


use Illuminate\Support\Str;


use BplanBase\CodeGenerator\Traits\DefinitionAttributes;


/**
 * Code Generator Definition Class
 *
 * @version     1.1.0 / 2024-10-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FieldDefinition
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use DefinitionAttributes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     ForeignKeyDefinition $_ForeignKeyDefinition
     */
    private $_ForeignKeyDefinition;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_technicalFieldNames
     */
    private static $_technicalFieldNames = [
        'active',
        'created_at',
        'deleted_at',
        'updated_at',
    ];


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $columnDefinition
     *
     * @param       array|null $additionalSettings
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $columnDefinition, array|null $additionalSettings)
    {
        $this->_init($columnDefinition, $additionalSettings);

    } // __construct()


    /**
     *
     * @param       array $columnDefinition
     *
     * @param       array|null $additionalSettings
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _init(array $columnDefinition, array|null $additionalSettings): self
    {
        $columnName = $columnDefinition['name'];
        $columnDefinition['name'] = $columnDefinition['isForeignKey']
            ? Str::camel(Str::replaceLast('_id', '', $columnName))
            : Str::camel($columnName);

        $type = $columnDefinition['type'];

        if (in_array($columnName, self::$_technicalFieldNames) && $columnName !== 'active') {
            $columnDefinition['readOnly'] = $columnDefinition['readOnly'] ?? true;
            $columnDefinition['sortable'] = $columnDefinition['sortable'] ?? true;

        } elseif ($columnName === 'id') {
            // /*
            // **  Die ID ist automatisch immer sortierbar. Wenn sie das nicht sein soll, dann muss das über "notSortable"
            // **  gesteuert werden. */
            // if (isset($columnDefinition['sortable']) && $columnDefinition['sortable'] === false) {
            //     $columnDefinition['notSortable'] = true;
            // } else {
            //     $columnDefinition['notSortable'] = false;
            // }
        }
        switch ($type) {
            case 'bigInteger':
                $abstractType = 'integer';
                $metaType = 'numeric';
                break;

            case 'boolean':
                $abstractType = 'bool';
                $metaType = 'boolean';
                break;

            case 'enum':
            case 'geometry':
            case 'json':
                $abstractType = 'string';
                $metaType = 'character';
                break;

            case 'timestamp':
                $abstractType = 'datetime';
                $metaType = 'datetime';
                break;

            default:
                $abstractType = $type;
                $metaType = 'undefined';
        }
        if ($columnName === 'id') {
            $abstractType = 'string';
            $metaType = 'numeric';
        }
        /*
                $columnName = $attributes['columns'][0];
                $relatedTable = $attributes['on'];
                $strippedColumnName = Str::replaceLast('_id', '', $columnName);

                unset($attributes['algorithm']);
                unset($attributes['columns']);
                unset($attributes['name']);
                unset($attributes['on']);

                $attributes['column'] = $column;
                $attributes['relatedTable'] = $relatedTable;
                $attributes['relationName'] = Str::slug($strippedColumn, '-');
                $attributes['relationNameCamelCase'] = Str::camel($strippedColumn, '-');
                $attributes['relationNameStudlyCaps'] = Str::studly($strippedColumn);
                $attributes['relationType'] = 'BelongsTo';
                $attributes['resourceName'] = Str::slug($relatedTable, '-');
                $attributes['resourceNameCamelCase'] = Str::camel($relatedTable, '-');
                $attributes['resourceNameStudlyCaps'] = Str::studly($relatedTable);

                ksort($attributes);

                $this->_columns[$columnName]['isForeignKey'] = true;
                $this->_columns[$columnName]['ForeignKeyDefinition'] = $attributes;
                $attributes['relationType'] = 'BelongsTo';

        */

        /*

        on-fields
        server-class
        meta

        */
        $ForeignKeyDefinition = $columnDefinition['ForeignKeyDefinition'] ?? null;

        unset($columnDefinition['ForeignKeyDefinition']);

        $this->_attributes = array_merge([
                'abstractType' => $abstractType,
                'autoIncrement' => false,
                'cast' => null,
                'columnName' => $columnName,
                'comment' => null,
                'default' => false,
                'hidden' => false,
                'length' => null,
                'metaType' => $metaType,
                'notSparseField' => false,
                'nullable' => false,
                'precision' => null,
                //'readOnly' => false,
                'readOnly' => null,
                'reverseRelationName' => null,
                'rules' => null,
                'ruleType' => null,
                //'sortable' => false,
                'sortable' => null,
                'unsigned' => false,
            ],
            $columnDefinition,
            $additionalSettings ?? []
        );
        $this->_ForeignKeyDefinition = $ForeignKeyDefinition;

        ksort($this->_attributes);

        return $this;

    } // _init()


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getForeignKeyDefinition()
    {
        return $this->_ForeignKeyDefinition;

    } // getForeignKeyDefinition()


    /**
     *
     * @return 	    mixed
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function isForeignKey(): bool
    {
        return $this->_attributes['isForeignKey'];

    } // isForeignKey()


    /**
     *
     * @param       string $attribute
     *
     * @param       mixed $value
     *
     * @return 	    mixed
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setAttribute(string $attribute, mixed $value): mixed
    {
        $this->_attributes[$attribute] = $value;

        return $this;

    } // setAttribute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @return 	    bool
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function isTechnicalField(string $name): bool
    {
        return in_array($name, self::$_technicalFieldNames);

    } // isTechnicalField()


} // class FieldDefinition {}
