<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     Avient
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Enums;


/**
 * Enum Class
 *
 * @version     4.0.0 / 2025-02-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum Generator: string {

    case CSharpJsonApiSerializer = 'csharp.jsonapiserializer';

    case CSharpNewtonsoftJsonApi = 'csharp.newtonsoftjsonapi';

    case CSharpNewtonsoftJson    = 'csharp.newtonsoft';

    case JsonApiPolicy           = 'jsonapi.policy';

    case JsonApiRequest          = 'jsonapi.request';

    case JsonApiRoute            = 'jsonapi.route';

    case JsonApiSchema           = 'jsonapi.schema';

    case JsonApiServer           = 'jsonapi.server';

    case LaravelActionCreate     = 'laravel.action.create';

    case LaravelActionDelete     = 'laravel.action.delete';

    case LaravelActionUpdate     = 'laravel.action.update';

    case LaravelBaseController   = 'laravel.base-controller';

    case LaravelController       = 'laravel.controller';

    case LaravelModel            = 'laravel.model';

    case LaravelObserver         = 'laravel.observer';

    case LaravelRepository       = 'laravel.repository';

    case LaravelService          = 'laravel.service';

    case WinMerge                = 'winmerge';

} // enum Generator {}
