<?php
/**
 * CSharp Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Definitions\TypeDefinition;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp\JsonApiSerializerGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp\NewtonsoftJsonGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp\NewtonsoftJsonApiGenerator;


/**
 * CSharp Code Generator Class
 *
 * @version     1.5.0 / 2025-02-19
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CSharpFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @version     3.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(TypeDefinition $TypeDefinition)
    {
        $this->_stubPath = CodeGenerator::getStubPath('csharp');

        parent::__construct($TypeDefinition);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @return      void
     *
     * @version     3.3.0 / 2025-02-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(TypeDefinition $TypeDefinition): void
    {
        new JsonApiSerializerGenerator($TypeDefinition);
        // new NewtonsoftJsonGenerator($TypeDefinition);
        // new NewtonsoftJsonApiGenerator($TypeDefinition);

    } // process()


} // class CSharpFileGenerator extends BaseFileGenerator {}
