<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     3.5.0 / 2025-02-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RepositoryGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir = 'app';


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Repositories';


    /**
     * @var     string $_modelNamespace
     */
    private $_modelNamespace = 'App\\Models';


    /**
     * @var     string $_namespace
     */
    protected $_namespace = 'App\\Repositories';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelRepository->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-02-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        if ($this->_TypeDefinition->isForPackage()) {
            $Package = $this->_TypeDefinition->getPackage();

            $packageNamespace = $Package->getNamespace();

            $this->_baseDir = $Package->getBaseDir();
            $this->_namespace = $packageNamespace.'\\Repositories';
            $this->_modelNamespace = $packageNamespace.'\\Models';
            $this->_package = $Package->getName();
            $this->_typeName = $Package->getPreparedTypeName($this->_typeName);
        }
        $this->_addUse('Illuminate\\Database\\Eloquent\\Collection');

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse($this->_modelNamespace.'\\'.$this->_typeName);

        return parent::_initUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.3.0 / 2025-02-15
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/repository.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        if ($this->_TypeDefinition->hasColumn('active')) {
            $fileContents = parent::replacePlaceholder('get-all-method', file_get_contents($this->_stubPath.'/snippets/repository/method.GetAll.active.stub'), $fileContents);
        } else {
            $fileContents = parent::replacePlaceholder('get-all-method', file_get_contents($this->_stubPath.'/snippets/repository/method.GetAll.stub'), $fileContents);
        }
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Repository-Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'Repository.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RepositoryGenerator extends LaravelFileGenerator {}
