<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Definitions\TypeDefinition;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ActionCreateGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ActionDeleteGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ActionUpdateGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ControllerGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ModelGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ObserverGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\RepositoryGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ServiceGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     1.4.0 / 2025-02-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LaravelFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @version     3.0.0 / 2024-10-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(TypeDefinition $TypeDefinition)
    {
        $this->_stubPath = CodeGenerator::getStubPath('laravel');

        parent::__construct($TypeDefinition);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       TypeDefinition $TypeDefinition
     *
     * @return      void
     *
     * @version     3.2.0 / 2025-02-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(TypeDefinition $TypeDefinition): void
    {
        new ModelGenerator($TypeDefinition);
        new ActionCreateGenerator($TypeDefinition);
        new ActionDeleteGenerator($TypeDefinition);
        new ActionUpdateGenerator($TypeDefinition);
        new ControllerGenerator($TypeDefinition);
        new ObserverGenerator($TypeDefinition);
        new RepositoryGenerator($TypeDefinition);
        new ServiceGenerator($TypeDefinition);

    } // process()


} // class LaravelFileGenerator extends BaseFileGenerator {}
