<?php
/**
 * Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-code-generator
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Providers;


use Illuminate\Console\Events\CommandFinished;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;


use BplanBase\CodeGenerator\Generators\CodeGenerator;


/**
 * Service Provider Class
 *
 * @version     1.0.0 / 2024-10-06
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EventServiceProvider extends ServiceProvider
{


    /* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     * The event listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Register any events for your application.
     *
     * @return      void
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot()
    {
        if (config('code-generator.active') === true) {
            Event::listen(function (CommandFinished $command) {
                if ($command->command === 'migrate' || $command->command === 'migrate:fresh' || $command->command === 'migrate:refresh') {
                    CodeGenerator::generate();
                }
            });
        }
    }


    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return      bool
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function shouldDiscoverEvents()
    {
        return false;

    } // shouldDiscoverEvents()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EventServiceProvider extends ServiceProvider {}
