<?php
/**
 * Code Generator BackReference Element Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Elements
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Elements;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Traits\HasAttributes;
use Illuminate\Support\Str;


/**
 * Code Generator BackReference Element Class
 *
 * @version     1.0.0 / 2025-03-04
 * @history     Definitions\BackReference, 2.0.0 / 2025-02-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BackReference
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasAttributes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_attributes<string, string>
     */
    protected $_attributes = [
        'tableName' => null,
        'tablePrefix' => null,
        'typeName' => null,
    ];


    /**
     * @var     string $_modelType
     */
    private $_modelType;


    /**
     * @var     null|Package $_Package
     */
    private $_Package;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $modelType
     *
     * @param       string $tableName
     *
     * @param       string $columnName
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $modelType, string $tableName, string $columnName)
    {
        $this->_attributes['columnName'] = $columnName;
        $this->_attributes['resourceName'] = Str::slug($tableName, '-');
        $this->_attributes['tableName'] = $tableName;

        $this->_modelType = $modelType;

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getModelType(): string
    {
        return $this->_modelType;

    } // getModelType()


    /**
     *
     * @return 	    null|Type
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRelatedType(): null|Type
    {
        return CodeGenerator::getType($this->_attributes['tableName']);

    } // getRelatedType()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BackReference {}
