<?php
/**
 * Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp;


use BplanBase\CodeGenerator\Elements\Field;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharpFileGenerator;


/**
 * Generator Class
 *
 * @version     2.0.0 / 2025-03-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class NewtonsoftJsonApiGenerator extends CSharpFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir = 'CSharp';


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = true;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Newtonsoft/JsonApi';


    /**
     * @var     string $_pluralTypeName
     */
    protected $_pluralTypeName;


    /**
     * @var     array $_jsonProperties
     */
    protected $_jsonProperties = [];


    /**
     * @var     array $_technicalProperties
     */
    protected $_technicalProperties = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::CSharpNewtonsoftJsonApi->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-10-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/newtonsoft-jsonapi.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('properties', $this->_preparePropertyReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('plural-type-name', $this->_pluralTypeName, $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2024-11-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _preparePropertyReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        ksort($this->_technicalProperties);

        foreach ($this->_technicalProperties as $property) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/newtonsoft-jsonapi/property.stub');

            $fileContents = parent::replacePlaceholder('name', $property['name'], $fileContents);
            $fileContents = parent::replacePlaceholder('property-name', $property['property-name'], $fileContents);
            $fileContents = parent::replacePlaceholder('type', $property['type'], $fileContents);

            $replacement .= $fileContents;
        }
        ksort($this->_jsonProperties);

        foreach ($this->_jsonProperties as $property) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/newtonsoft-jsonapi/property.stub');

            $fileContents = parent::replacePlaceholder('name', $property['name'], $fileContents);
            $fileContents = parent::replacePlaceholder('property-name', $property['property-name'], $fileContents);
            $fileContents = parent::replacePlaceholder('type', $property['type'], $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _preparePropertyReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processType();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-04
     * @history     NewtonsoftJsonApiGenerator::_processTypeDefinition(), 1.2.0 / 2024-11-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processType(): self
    {
        foreach ($this->_Type->getFields($this->_tableName) as $Field) {
            $this->_pluralTypeName = $this->_Type->getBaseName(CaseStyle::Studly, Number::Plural);

            if ($Field->getAttribute('isForeignKey') === true) {
                continue;
            }
            $columnName = $Field->getAttribute('columnName');

            if ($columnName === 'id') {
                continue;
            }
            $type = $Field->getAttribute('type');

            $jsonName = $Field->getAttribute('name', CaseStyle::Camel);
            $varName = $Field->getAttribute('name', CaseStyle::Studly);

            switch ($type) {
                case 'bigInteger':
                case 'integer':
                case 'unsignedInteger':
                    $abstractType = 'int';
                    break;

                case 'boolean':
                    $abstractType = 'bool';
                    break;

                case 'datetime':
                case 'timestamp':
                    $abstractType = 'DateTime';
                    break;

                case 'enum':
                case 'geometry':
                case 'json':
                    $abstractType = 'string';
                    break;

                default:
                    $abstractType = $type;
            }
            if (Field::isTechnicalField($columnName)) {
                $this->_technicalProperties[$jsonName] = [
                    'name' => $varName,
                    'property-name' => $jsonName,
                    'type' => $abstractType,
                ];
                continue;
            }
            $this->_jsonProperties[$jsonName] = [
                'name' => $varName,
                'property-name' => $jsonName,
                'type' => $abstractType,
            ];
        }
        return $this;

    } // _processType()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Klasse schreiben. */
        parent::_writeFileContents($this->_typeName.'.cs', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class NewtonsoftJsonApiGenerator extends CSharpFileGenerator {}
