<?php
/**
 * Attribute Trait
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Traits
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Traits;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Helpers\StringHelper;


/**
 * Attribute Trait
 *
 * @version     1.0.0 / 2025-03-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
trait HasAttributes
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @param       CaseStyle|null $CaseStyle
     *
     * @param       Number|null $Number
     *
     * @return 	    mixed
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAttribute(string $name, CaseStyle|null $CaseStyle = null, Number|null $Number = null): mixed
    {
        if (!isset($this->_attributes[$name])) {
            return null;
        }
        $value = $this->_attributes[$name];

        if (!is_string($value) || $value === '') {
            return $value;
        }
        if ($CaseStyle !== null || $Number !== null) {
            $value = StringHelper::reformat($value, $CaseStyle, $Number);
        }
        return $value;

    } // getAttribute()


    /**
     *
     * @param       string $attribute
     *
     * @param       mixed $value
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setAttribute(string $attribute, mixed $value): self
    {
        $this->_attributes[$attribute] = $value;

        return $this;

    } // setAttribute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // trait HasAttributes {}
