# Laravel Code Generator

A package for the dynamic generation of program codes based on migrations or database schemas.

## Description

The code generator uses the blueprint objects defined in the migration files and automatically generates PHP code from the information contained therein (see “Usage”).
All generated files can be reworked and extended manually. By removing the Code Generator tag, which is inserted in the first line of every generated file, modified files can be protected from future changes by the Code Generator.

Below is an overview of the generated files.

### Laravel

* Actions - classes for create, update & delete (usually no adjustment required)
* Form-Requests - fully featured (usually no adjustment required)
* Http-Controllers - basic structure (intended for manual adjustment)
* Models - fully featured (usually no adjustment required) with relation methods
* Observers - basic structure (intended for manual adjustment)
* Repositories - default methods (getAll(), getById(), ...)
* Services - default methods for create, update & delete

### JsonApi

* Server - Data & Terminal (usually no adjustment required)
* Schemas - all servers, fully featured (usually no adjustment required)
* Requests - all servers, fully featured (usually no adjustment required)
* Policies - fully featured (usually no adjustment required)
* Route files - all servers, fully featured (usually no adjustment required)

### Livewire

* Components - Index, Modals/Create, Modals/Edit (intended for manual adjustment)

### C#

* Model classes

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:
```bash
composer config repositories.bplan/composer-packages composer https://satis.bplan.solutions
```

The package can then be installed as a dev-dependency:
```bash
composer require bplan-base/laravel-code-generator --dev
```
In addition to this package, the package `bplan-base/laravel-code-generator-loader` is also required. However, the loader is already installed by the `bplan-base/globals` package by default and therefore does not need to be installed separately.

## Configuration

There are various configuration options that can be set via the `.env` configuration file.

Activate the Code Generator:
```toml
CODE_GENERATOR_ACTIVE = true
```
Automatic code generation is deactivated by default.

The code generator generates files for Laravel, Livewire, JsonApi and C#. All files are generated by default. Only the generation of the JsonApi and C# classes can be controlled:
```toml
CODE_GENERATOR_CREATE_JSONAPI = false
CODE_GENERATOR_CREATE_CSHARP = false
```
The generation of C# files ist activated by default. There is currently only one generator for NewtonSoft classes. The generated classes are stored in the directory `storage/app/build/CodeGenerator/CSharp/NewtonSoft`.

During development, the Code Generator may not be able to complete its work due to an error that occurs during the execution of the migration. It may then not be possible to run the migration again because the required relations have not been created.
In this case, the following configuration setting can be entered in the `.env` file:
```toml
CODE_GENERATOR_SKIP_ROUTING = true
```
There is currently only one generator for C# NewtonSoft classes. The generated classes are stored in the directory `storage/app/build/CodeGenerator/CSharp/NewtonSoft`.
Both, the generation of JsonApi and C# files, are activated by default. 

## Usage

The creation of classes is triggered by an extension of the migration. The following example shows how the code generator must be inserted into a migration:
```php
<?php

use BplanBase\CodeGenerator\Generators\CodeGenerator;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamps();

            $Table->foreignId('current_team_id')->nullable();
            $Table->string('email')->unique();
            $Table->timestamp('email_verified_at')->nullable();
            $Table->string('name');
            $Table->string('password');
            $Table->string('profile_photo_path', 2048)->nullable();
            $Table->rememberToken();

            new CodeGenerator($Table, [
                // settings
            ]);
        });
    } // up()

}
```
The example shown here describes the minimum settings required to create all classes for the type to which the migration belongs. The second parameter (`settings`) is optional, but in many cases it is necessary to achieve an optimal result with little to no manual adjustments. The options that can be used in `settings` are described in a separate document (coming soon).

## Dependencies
* "php": "*"

