<?php
/**
 * Code Generator BackReference Element Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Elements
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Elements;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\ModelType;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Traits\HasAttributes;
use Illuminate\Support\Str;


/**
 * Code Generator BackReference Element Class
 *
 * @version     1.1.0 / 2025-03-10
 * @history     Definitions\BackReference, 2.0.0 / 2025-02-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BackReference
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use HasAttributes;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_attributes<string, string>
     */
    protected $_attributes = [
        'tableName' => null,
        'tablePrefix' => null,
        'typeName' => null,
    ];


    /**
     * @var     ModelType $_ModelType
     */
    private $_ModelType;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $ModelType
     *
     * @param       string $tableName
     *
     * @param       string $columnName
     *
     * @version     2.0.0 / 2025-03-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(ModelType $ModelType, string $tableName, string $columnName)
    {
        $this->_attributes['columnName'] = $columnName;
        $this->_attributes['resourceName'] = Str::slug($tableName, '-');
        $this->_attributes['tableName'] = $tableName;

        $this->_ModelType = $ModelType;

    } // __construct()


    /**
     *
     * @return 	    ModelType
     *
     * @version     2.0.0 / 2025-03-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getModelType(): ModelType
    {
        return $this->_ModelType;

    } // getModelType()


    /**
     *
     * @return 	    null|Type
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRelatedType(): null|Type
    {
        return CodeGenerator::getType($this->_attributes['tableName']);

    } // getRelatedType()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BackReference {}
