<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Enums;


/**
 * Enum Class
 *
 * @version     17.0.0 / 2025-06-12
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum Generator: string {

    case CodeGeneratorInit        = 'code-generator.init';

    case CSharpJsonApiSerializer  = 'csharp.jsonapiserializer';

    case CSharpNewtonsoftJsonApi  = 'csharp.newtonsoftjsonapi';

    case CSharpNewtonsoftJson     = 'csharp.newtonsoft';

    case JsonApiDerivedRequest    = 'jsonapi.derived.request';

    case JsonApiDerivedSchema     = 'jsonapi.derived.schema';

    case JsonApiRequest           = 'jsonapi.request';

    case JsonApiRoute             = 'jsonapi.route';

    case JsonApiSchema            = 'jsonapi.schema';

    case JsonApiServer            = 'jsonapi.server';

    case LaravelActionCreate      = 'laravel.action.create';

    case LaravelActionDelete      = 'laravel.action.delete';

    case LaravelActionUpdate      = 'laravel.action.update';

    case LaravelController        = 'laravel.controller';

    case LaravelDerivedModel      = 'laravel.derived.model';

    // case LaravelDerivedObserver   = 'laravel.derived.observer';

    case LaravelDerivedPolicy     = 'laravel.derived.policy';

    // case LaravelDerivedRepository = 'laravel.derived.repository';

    // case LaravelDerivedService    = 'laravel.derived.service';

    case LaravelFormRequestStore  = 'laravel.form-request.store';

    case LaravelFormRequestUpdate = 'laravel.form-request.update';

    case LaravelModel             = 'laravel.model';

    case LaravelObserver          = 'laravel.observer';

    case LaravelPolicy            = 'laravel.policy';

    case LaravelRepository        = 'laravel.repository';

    case LaravelService           = 'laravel.service';

    case LivewireIndex            = 'livewire.index';

    case LivewireModalCreate      = 'livewire.modal.create';

    case LivewireModalEdit        = 'livewire.modal.edit';

    case WinMerge                 = 'winmerge';

} // enum Generator {}
