<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Generators\CodeGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     2.2.0 / 2025-05-20
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DerivedObserverGenerator extends ObserverGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias = 'PackageObserver';


    /**
     * @var     GeneratorMode $_GeneratorMode
     */
    protected $_GeneratorMode = GeneratorMode::Derived;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelDerivedObserver->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $baseClass = $this->_typeName.'Observer';

        $this->_addUse($this->_packageNamespace.'\\Models\\'.$this->_typeName.' as Base'.$this->_typeName);
        $this->_addUse($this->_packageNamespace.'\\Observers\\'.$baseClass.' as '.$this->_baseClassAlias);
        /*
        **  Originales Package durch das Projekt-Package ersetzen. */
        $this->_Package = CodeGenerator::getProjectPackage();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_addUse($this->_packageNamespace.'\\Models\\'.$this->_typeName);

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $this->_packageNamespace.'\\Models';
        $this->_namespace = $this->_packageNamespace.'\\Observers';
        $this->_typeHint .= '|'.'Base'.$this->_typeName;

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-04-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Observer-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Observer.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class DerivedObserverGenerator extends ObserverGenerator {}
