<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     3.10.0 / 2025-06-19
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ServiceGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_actionNamespace
     */
    private $_actionNamespace;


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias;


    /**
     * Der Namespace der übergeordneten Model-Klasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseModelNamespace;
     */
    protected $_baseModelNamespace;


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Services';


    /**
     * @var     string $_modelNamespace
     */
    protected $_modelNamespace;


    /**
     * @var     string $_packageNamespace
     */
    protected $_packageNamespace;


    /**
     * @var     string $_typeNameCamel
     */
    protected $_typeNameCamel;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelService->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     2.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        if ($Type->hasExclude(Generator::LaravelActionCreate)
         && $Type->hasExclude(Generator::LaravelActionDelete)
         && $Type->hasExclude(Generator::LaravelActionUpdate)) {
            $this->_exclude = true;
        }
        parent::__construct($Type);

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.5.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $fileContents = file_get_contents($this->_stubPath.'/service.stub');
            /*
            **  Die Methoden-Templates müssen zuerst eingefügt werden, damit im Anschluss auch die
            **  weiteren darin verwendeten Platzhalter ersetzt werden können. */
            $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('action-namespace', $this->_actionNamespace, $fileContents);
            $fileContents = parent::replacePlaceholder('type-name-camel', $this->_typeNameCamel, $fileContents);

        } else {
            $fileContents = file_get_contents($this->_stubPath.'/derived.service.stub');

            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClassAlias, $fileContents);
        }
        $fileContents = parent::replacePlaceholder('model-namespace', $this->_modelNamespace, $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-hint', $this->_typeHint, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.8.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseModelNamespace = $this->_packageNamespace.'\\Models';
        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_actionNamespace = $this->_packageNamespace.'\\Actions';
        $this->_modelNamespace = $this->_packageNamespace.'\\Models';
        $this->_namespace = $this->_packageNamespace.'\\Services';
        $this->_typeHint = $this->_typeName;
        $this->_typeNameCamel = $this->_Type->getBaseName(CaseStyle::Camel, Number::Singular);

        if ($this->_PackageType === PackageType::Package) {
            if ($this->_GeneratorMode === GeneratorMode::Default) {
                $this->_typeHint .= '|'.'Derived'.$this->_typeName;
            }
        }
        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.5.0 / 2025-06-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        if ($this->_GeneratorMode === GeneratorMode::Default) {
           if ($this->_Type->hasExclude(Generator::LaravelActionCreate) === false) {
               $this->_addUse($this->_actionNamespace.'\\'.$this->_typeNamePlural.'\\Create');
           }
           if ($this->_Type->hasExclude(Generator::LaravelActionDelete) === false) {
               $this->_addUse($this->_actionNamespace.'\\'.$this->_typeNamePlural.'\\Delete');
           }
           if ($this->_Type->hasExclude(Generator::LaravelActionUpdate) === false) {
               $this->_addUse($this->_actionNamespace.'\\'.$this->_typeNamePlural.'\\Update');
           }
        }
        $this->_addUse($this->_modelNamespace.'\\'.$this->_typeName);
        $this->_addUse('Illuminate\\Database\\Eloquent\\Model');

        if ($this->_PackageType === PackageType::Package) {
            if ($this->_GeneratorMode === GeneratorMode::Default) {
                // $this->_addUse('App\\Models\\'.$this->_typeName.' as Derived'.$this->_typeName);
            }
        }
        return parent::_prepareUses();

    } // _initUses()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.4.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareMethodReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Action-Methoden zusammenstellen. */
        $replacement = '';

        if ($this->_Type->hasExclude(Generator::LaravelActionCreate) === false) {
            $replacement .= file_get_contents($this->_stubPath.'/snippets/service/method.create.stub');
        }
        if ($this->_Type->hasExclude(Generator::LaravelActionDelete) === false) {
            $replacement .= file_get_contents($this->_stubPath.'/snippets/service/method.delete.stub');
        }
        if ($this->_Type->hasExclude(Generator::LaravelActionUpdate) === false) {
            $replacement .= file_get_contents($this->_stubPath.'/snippets/service/method.update.stub');
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-06-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Service-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Service.php', $fileContents);

        // if ($this->_PackageType === PackageType::Package) {
        //     new DerivedServiceGenerator($this->_Type);
        // }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ServiceGenerator extends LaravelFileGenerator {}
