<?php
/**
 * Base File Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator;


/**
 * Base File Generator Class
 *
 * @version     1.8.0 / 2025-03-10
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class BaseFileGenerator extends BaseGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     bool $_exclude
     */
    protected $_exclude = false;


    /**
     * @var     array $_Fields
     */
    protected $_Fields;


    /**
     * @var     ModelType $_ModelType
     */
    protected $_ModelType;


    /**
     * @var     Package $_Package
     */
    protected $_Package;


    /**
     * @var     string $_stubPath
     */
    protected $_stubPath;


    /**
     * @var     string $_tableName
     */
    protected $_tableName;


    /**
     * @var     Type $_Type
     */
    protected $_Type;


    /**
     * @var     string $_typeName
     */
    protected $_typeName;


    /**
     * @var     string $_typeNamePlural
     */
    protected $_typeNamePlural;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     4.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        if ($this->_exclude === true || $Type->hasExclude(static::$_generator)) {
            CodeGenerator::output('Omitting ', bullet: true, color: CodeGenerator::getOutputColor('omitting'), file: static::$_generator);

            return;
        }
        $this->_Type = $Type;

        $this->_init();
        $this->_process();

    } // __construct()


    /**
     *
     * @param       Type $Type
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-03-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        $this->_ModelType = $this->_Type->getModelType();
        $this->_Package = $this->_Type->getPackage();
        $this->_typeName = $this->_Type->getBaseName(CaseStyle::Studly, Number::Singular);
        $this->_typeNamePlural = $this->_Type->getBaseName(CaseStyle::Studly, Number::Plural);

        parent::_init();

        $this->_tableName = $this->_Type->getAttribute('tableName');
        $this->_Fields = $this->_Type->getFields($this->_tableName);

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class BaseFileGenerator extends BaseGenerator {}
