<?php
/**
 * CSharp Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp\JsonApiSerializerGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp\NewtonsoftJsonGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\CSharp\NewtonsoftJsonApiGenerator;


/**
 * CSharp Code Generator Class
 *
 * @version     1.6.0 / 2025-03-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CSharpFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     4.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        $this->_stubPath = CodeGenerator::getStubPath('csharp');

        parent::__construct($Type);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @return      void
     *
     * @version     4.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(Type $Type): void
    {
        new JsonApiSerializerGenerator($Type);
        new NewtonsoftJsonGenerator($Type);
        new NewtonsoftJsonApiGenerator($Type);

    } // process()


} // class CSharpFileGenerator extends BaseFileGenerator {}
