<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @todo        UserSchema          currentTeamId
 *
 * @todo        Methode _processAdditionalRelations()   >   Relationentyp prüfen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Elements\Field;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\ModelType;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;
use Illuminate\Support\Str;


/**
 * JasonApi Code Generator Class
 *
 * @version     6.2.0 / 2025-03-10
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SchemaGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_appends
     */
    protected $_appends = [];


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir = 'app';


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     string $_idField
     */
    private $_idField;


    /**
     * @var     array $_regularFields
     */
    private $_regularFields = [];


    /**
     * @var     array $_relationFields
     */
    private $_relationFields = [];


    /**
     * @var     array $_technicalFields
     */
    private $_technicalFields = [];


    /**
     * @var     string $_timezone
     */
    private $_timezoneReplacement = '';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiSchema->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $methodName
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addRelation(string $name, string $type, string $resourceName): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Multiple relations ['.$type.' '.$name.']');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] =
                $this->_relationFields[$key];
            }
            $this->_errors[$key][] = [
                'name' => $name,
                'resourceName' => $resourceName,
                'type' => $type,
            ];
            $key .= '-failure';
            $name .= '-failure';

        }
        $this->_relationFields[$key] = [
            'name' => $name,
            'resourceName' => $resourceName,
            'type' => $type,
        ];
        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    string
     *
     * @version     1.4.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/schema.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('fields', $this->_prepareFieldReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('timezone', $this->_timezoneReplacement, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.8.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();
        /*
        **  Hier müssen die Server aus dem Type - und nicht die aus der Konfiguration - verwendet
        **  werden, weil der Aktivierungsstatus möglicherweise geändert ist. */
        $this->_jsonApiServers = $this->_Type->getJsonApiServers();

        $modelNamespace = 'App\\Models';

        $this->_namespace = 'App\\'.$this->_jsonApiNameSpace;

        if ($this->_Type->isForPackage()) {
            $Package = $this->_Type->getPackage();

            $packageNamespace = $Package->getNamespace();
            $modelNamespace = $packageNamespace.'\\Models';

            $this->_baseDir = $Package->getBaseDir();
            $this->_namespace = $packageNamespace.'\\'.$this->_jsonApiNameSpace;
            $this->_packageName = $Package->getName();
        }
        $this->_addUse($modelNamespace.'\\'.$this->_typeName);

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-02-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            'Illuminate\\Database\\Eloquent\\Builder',
            'Illuminate\\Http\\Request',
            'LaravelJsonApi\\Eloquent\\Contracts\\Paginator',
            'LaravelJsonApi\\Eloquent\\Filters\\WhereIdIn',
            'LaravelJsonApi\\Eloquent\\Pagination\\PagePagination',
            'LaravelJsonApi\\Eloquent\\Schema',
        ]);
        return parent::_initUses();

    } // _initUses()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.4.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareFieldReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Felddefinitionen zusammenstellen. */
        $padding = str_repeat(' ', 12);
        $replacement = '';

        if ($this->_idField !== null) {
            $replacement .= "\n".$padding.$this->_idField;
        }
        if (!empty($this->_technicalFields)) {
            ksort($this->_technicalFields);

            $replacement .= "\n";

            foreach ($this->_technicalFields as $field) {
                $replacement .= "\n".$padding.$field;
            }
        }
        if (!empty($this->_regularFields)) {
            ksort($this->_regularFields);

            $replacement .= "\n";

            foreach ($this->_regularFields as $key => $field) {
                $replacement .= "\n".$padding.$field;
            }
        }
        if (!empty($this->_appends)) {
            $replacement .= "\n".$padding.'/*'
                ."\n".$padding.'**  Appended fields */';

            foreach ($this->_appends as $appendField) {
                $replacement .= "\n".$padding.$appendField;
            }
        }
        if (!empty($this->_relationFields)) {
            /*
            **  Relationen-Felder abarbeiten. */
            ksort($this->_relationFields);

            $replacement .= "\n".$padding.'/*'
                ."\n".$padding.'**  Relations */';

            foreach ($this->_relationFields as $relation) {
                $replacement .= "\n".$padding.$relation['type'].'::make(\''.$relation['name'].'\')->type(\''.$relation['resourceName'].'\')->serializeUsing('
                    ."\n".$padding.'    static fn($Relation) => $Relation->alwaysShowData()'
                    ."\n".$padding.'),';
            }
        }
        $replacement .= "\n";

        return $replacement;

    } // _prepareFieldReplacement()


    /**
     *
     * @param       Field $Field
     *
     * @return 	    string
     *
     * @version     3.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareRegularField(Field $Field): string
    {
        $columnName = $Field->getAttribute('name');
        $nameCamelCase = $Field->getAttribute('name', CaseStyle::Camel);

        $addNewline = '';
        $basePadding = str_repeat(' ', 8);
        $padding = str_repeat(' ', 12);

        switch ($Field->getAttribute('abstractType')) {
            case 'bool':
                $field = 'Boolean::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Boolean');
                break;

            case 'datetime':
                /*
                **  Sonderbehandlung für die Felder "created_at", "deleted_at" und "updated_at".
                **  Diese Felder sind automatisch "readOnly" und "sortable", sofern in der Migration keine
                **  abweichende Einstellung vorgenommen wurde. */
                if (Field::isTechnicalField($columnName)) {
                    $Field->setAttribute('hidden', $Field->getAttribute('hidden') ?? true);
                    $Field->setAttribute('readOnly', $Field->getAttribute('readOnly') ?? true);
                    $Field->setAttribute('sortable', $Field->getAttribute('sortable') ?? true);
                }
                $addNewline = "\n";

                $field = 'DateTime::make(\''.$nameCamelCase.'\')->serializeUsing('
                    ."\n".$padding.'    static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format(\'c\') : null'
                    ."\n".$padding.')';

                $this->_timezoneReplacement = "\n"
                    ."\n".$basePadding.'$timezone = config(\'app.timezone\');'
                    ."\n";

                $this->_addUse('Carbon\\Carbon');
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\DateTime');
                break;

            case 'string':
                if ($Field->getAttribute('type') === 'json') {
                    $jsonType = 'Array'.($Field->getAttribute('jsonType') ?? CodeGenerator::JSON_TYPE_ARRAY);

                    $field = $jsonType.'::make(\''.$nameCamelCase.'\')';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\'.$jsonType);

                } else {
                    $field = 'Str::make(\''.$nameCamelCase.'\')';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
                }
                break;

            case 'integer':
                $field = 'Number::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Number');
                break;

            default:
                $field = 'Str::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
        }
        if ($Field->getAttribute('hidden') === true) {
            $field .= '->hidden()';
        }
        if ($Field->getAttribute('readOnly') === true) {
            $field .= '->readOnly()';
        }
        if ($Field->getAttribute('sortable') === true) {
            $field .= '->sortable()';
        }
        $field .= ','.$addNewline;

        return $field;

    } // _prepareRegularField()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processType();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_Type->getAdditionalRelations() as $additionalRelation) {
            $relationName = $additionalRelation['relationName'];
            $relationType = $additionalRelation['relationType'];
            $resourceName = $additionalRelation['resourceName'];
// @todo    Relationentyp prüfen
            if ($relationType === 'HasManyThrough') {
                $relationType = 'HasMany';
            }
            $this->_addRelation($relationName, $relationType, $resourceName);

            $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAppendFields(): self
    {
        $appends = $this->_Type->getAppends();

        if (!empty($appends)) {
            ksort($appends);
            /*
            **  Ersetzungs-String für die Attribute-Methoden zusammenstellen. */
            foreach ($appends as $append) {
                $generator = self::$_generator;

                if (!isset($append['generators'][$generator])) {
                    continue;
                }
                $field = Str::camel($append['field']);
                /*
                **  Appends-Felder werden der Einfahheit halber immer als String-Felder angelegt. Bisher gab es
                **  noch keinen Grund die Felder spezieller zu definieren. */
                $this->_appends[] = 'Str::make(\''.$field.'\'),';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
            }
        }
        return $this;

    } // _processAppendFields()


    /**
     *
     * @return 	    $this
     *
     * @version     1.7.0 / 2025-03-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getAttribute('columnName');

                $RelatedType = $BackReference->getRelatedType();

                if ($BackReference->getModelType() === ModelType::Pivot) {
                    $pivotTables = $RelatedType->getPivotTables();

                    if (isset($pivotTables[$this->_tableName])) {
                        $Type = CodeGenerator::getType($pivotTables[$this->_tableName]);

                        $resourceName = $Type->getBaseName(CaseStyle::Slug, Number::Plural);
                        $relationType = 'BelongsToMany';

                    } else {
                        //
                    }
                } else {
                    $resourceName = $RelatedType->getBaseName(CaseStyle::Slug, Number::Plural);
                    $relationType = 'HasMany';
                }
                $foreignKey = $RelatedType->getForeignKey($columnName);

                if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    $relationName = $foreignKey['reverseRelationName'];
                } else {
                    $relationName = $resourceName;
                }
                $this->_addRelation($relationName, $relationType, $resourceName);
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-04
     * @history     SchemaGenerator::_processTypeDefinition(), 1.4.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processType(): self
    {
        /*
        **  Felddefinitionen zusammenstellen. */
        foreach ($this->_Fields as $Field) {
            $columnName = $Field->getAttribute('name', CaseStyle::Snake);
            $nameCamelCase = $Field->getAttribute('name', CaseStyle::Camel);
            /*
                todo    Sonderfall berücksichtigen:
                        Der Primary-Key id kann unter Umständen kein AutoIncrement sein, wenn er
                        ein Foreign-Key auf eine andere Tabelle ist.
            */
            if ($Field->getAttribute('autoIncrement') === true) {
                if ($columnName === 'id') {
                    $this->_idField = 'ID::make(),';
                } else {
                    $this->_idField = 'ID::make(\''.$nameCamelCase.'\')';
                }
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\ID');

                continue;
            }
            /*
            **  Foreign-Keys abarbeiten. */
            if ($Field->isForeignKey() === true) {
                $relationName = $Field->getAttribute('relationName');
                $resourceName = $Field->getRelatedType()->getBaseName(CaseStyle::Slug, Number::Plural);

                $this->_addRelation($relationName, 'BelongsTo', $resourceName);
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\BelongsTo');

                continue;
            }
            $field = $this->_prepareRegularField($Field);

            if (Field::isTechnicalField($columnName)) {
                $this->_technicalFields[$nameCamelCase] = $field;

                continue;
            }
            $this->_regularFields[strtolower($nameCamelCase)] = $field;
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_processAppendFields();
        $this->_initUses();

        return $this;

    } // _processType()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Schema-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach ($this->_jsonApiServers as $server => $status) {
            if ($status === false) {
                continue;
            }
            $indexQueryCode = $this->_Type->getIndexQuery($server);
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $fileContents = parent::replacePlaceholder('index-query', $indexQueryCode ?? '$Query', $baseFileContents);
            $fileContents = parent::replacePlaceholder('namespace-addition', $server.'\\'.$this->_typeNamePlural, $fileContents);
            /*
            **  Schema-Klasse schreiben. */
            $this->_filePath = 'JsonApi/'.$server.'/'.$this->_typeNamePlural;

            parent::_writeFileContents($this->_typeName.'Schema.php', $fileContents, $this->_packageName);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SchemaGenerator extends JsonApiFileGenerator {}
