<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\ModelType;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;
use Illuminate\Support\Str;


/**
 * JasonApi Code Generator Class
 *
 * @version     5.2.0 / 2025-03-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PolicyGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Policies';


    /**
     * @var     string $_modelNamespace
     */
    private $_modelNamespace;


    /**
     * @var     array $_relationFields
     */
    private $_relationFields = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiPolicy->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addRelation(string $name): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Duplicate relation ['.$name.']');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] = $this->_relationFields[$key];
            }
            $this->_errors[$key][] = $name;

            $key .= 'Failure';
            $name .= 'Failure';
        }
        $this->_relationFields[$key] = $name;

        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    $this
     *
     * @version     1.7.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $packageNamespace.'\\Models';
        $this->_namespace = $packageNamespace.'\\Policies';

        $this->_addUse('Illuminate\\Auth\\Access\\Response');

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            $this->_modelNamespace.'\\'.$this->_typeName,
            'App\\Models\\User',
        ]);
        return parent::_initUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/policy.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.1 / 2024-10-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareMethodReplacement(): string
    {
        ksort($this->_relationFields);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_relationFields as $relationName) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/policy/method.stub');

            $fileContents = parent::replacePlaceholder('method', $relationName, $fileContents);
            $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processType();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_Type->getAdditionalRelations() as $additionalRelation) {
            $methodName = Str::studly($additionalRelation['relationName']);

            $this->_addRelation($methodName);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-03-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getAttribute('columnName');

                $RelatedType = $BackReference->getRelatedType();

                if ($BackReference->getModelType() === ModelType::Pivot) {
                    $pivotTables = $RelatedType->getPivotTables();

                    if (isset($pivotTables[$this->_tableName])) {
                        $Type = CodeGenerator::getType($pivotTables[$this->_tableName]);

                    } else {
                        //
                    }
                } else {
                    $Type = $BackReference->getRelatedType();
                }
                $foreignKey = $RelatedType->getForeignKey($columnName);
                $methodName = $Type->getBaseName(CaseStyle::Studly, Number::Plural);

                if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    // TODO
                    $methodName = Str::studly($foreignKey['reverseRelationName']);
                }
                $this->_addRelation($methodName);
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-04
     * @history     PolicyGenerator::_processTypeDefinition(), 1.4.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processType(): self
    {
        /*
        **  Foreign-Keys abarbeiten. */
        foreach ($this->_Fields as $Field) {
            if ($Field->isForeignKey() === true) {
                if ($Field->isForeignKey() === false) {
                    continue;
                }
                $methodName = $Field->getBaseName(CaseStyle::Studly, Number::Singular);

                $this->_addRelation($methodName);
            }
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_initUses();

        return $this;

    } // _processType()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Policy-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Policy.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PolicyGenerator extends JsonApiFileGenerator {}
