<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Klasse UserRequest      currentTeamId
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Elements\Field;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     5.1.0 / 2025-03-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RequestGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     array $_foreignKeys
     */
    private $_foreignKeys = [];


    /**
     * @var     integer $_maxFieldNameLength
     */
    private $_maxFieldNameLength = 0;


    /**
     * @var     array $_rules
     */
    private $_rules = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiRequest->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-11-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/request.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('rules', $this->_prepareRuleReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.8.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();
        /*
        **  Hier müssen die Server aus dem Type - und nicht die aus der Konfiguration - verwendet
        **  werden, weil der Aktivierungsstatus möglicherweise geändert ist. */
        $this->_jsonApiServers = $this->_Type->getJsonApiServers();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_namespace = $this->_Package->getNamespace().'\\'.$this->_jsonApiNameSpace;

        $this->_addUse('LaravelJsonApi\\Laravel\\Http\Requests\\ResourceRequest');

        return $this;

    } // _init()


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareFieldRules(Field $Field, string $fieldName)
    {
        $rules = $Field->getAttribute('rules');
        $ruleType = $Field->getAttribute('ruleType');
        $type = $Field->getAttribute('type');

        if ($rules !== null) {
            $this->_rules[$fieldName] = $rules;

            return $this;
        }
        $fieldRules = [];

        if ($Field->getAttribute('nullable') === true) {
            $fieldRules['nullable'] = 'nullable';

        } else {
            /*
            **  Wenn das Feld eigentlich "required" ist, es aber einen Default-Wert gibt, dann
            **  wird "sometimes" eingesetzt. Das bewirkt, dass das Feld in den Request-Daten
            **  auch fehlen darf. */
            if ($Field->getAttribute('default') !== false) {
                $fieldRules['sometimes'] = 'sometimes';
            }
            $fieldRules['nullable'] = 'required';
        }
        if ($ruleType !== null) {
            $fieldRules['type'] = $ruleType;

            if ($Field->getAttribute('length') !== null) {
                $fieldRules[] = 'max:'.$Field->getAttribute('length');
            }
            $this->_rules[$fieldName] = $fieldRules;

            return $this;
        }
        switch ($Field->getAttribute('abstractType')) {
            case 'bool':
                $fieldRules = 'JsonApiRule::boolean()';

                $this->_addUse('LaravelJsonApi\\Validation\\Rule as JsonApiRule');

                break;

            case 'datetime':
                $fieldRules['type'] = 'date';
                break;

            case 'integer':
                $fieldRules['type'] = 'integer';
                break;

            case 'string':
                if ($type === 'json') {
                    /*
                    **  Json-Felder müssen mit einem leeren Rule-Array angelegt werden. */
                    $fieldRules = [];

                } else {
                    $fieldRules['type'] = 'string';
                }
                if ($Field->getAttribute('length') !== null) {
                    $fieldRules[] = 'max:'.$Field->getAttribute('length');
                }
                break;

            default:
        }
        $this->_rules[$fieldName] = $fieldRules;

        return $this;

    } // _prepareFieldRules()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareRuleReplacement(): string
    {
        $padding = str_repeat(' ', 12);

        ksort($this->_rules);
        /*
        **  Ersetzungs-String für die Felddefinitionen zusammenstellen. */
        $replacement = '';

        if (!empty($this->_rules)) {
            foreach ($this->_rules as $field => $rules) {
                if (is_array($rules)) {
                    $replacement .= "\n".$padding
                        .str_pad("'".$field."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                        .' => [';

                    $separator = '';

                    foreach ($rules as $rule) {
                        if (strpos($rule, 'Rule::') !== false) {
                            $quotedRule = $rule;

                        } else {
                            $quotedRule = "'".$rule."'";
                        }
                        $replacement .= $separator.$quotedRule;
                        $separator = ', ';
                    }
                    $replacement .= '],';

                } else {
                    $replacement .= "\n".$padding
                        .str_pad("'".$field."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                        .' => '.$rules.',';
                }
            }
            $replacement .= "\n";
        }
        if (!empty($this->_foreignKeys)) {
            foreach ($this->_foreignKeys as $name) {
                $replacement .= "\n".$padding
                    .str_pad("'".$name."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                    .' => JsonApiRule::toOne(),';
            }
            $replacement .= "\n";
        }
        return $replacement;

    } // _prepareRuleReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processFields();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-04
     * @history     RequestGenerator::_processTypeDefinition(), 1.6.0 / 2025-02-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processFields(): self
    {
        /*
        **  Technische/automatische Felder, die übersprungen werden sollen. */
        $skipColumns = [
            'created_at' => true,
            'deleted_at' => true,
            'updated_at' => true,
        ];
        /*
        **  Felddefinitionen zusammenstellen. */
        foreach ($this->_Fields as $Field) {
            if ($Field->getAttribute('autoIncrement') === true) {
                continue;
            }
            if ($Field->getAttribute('guarded') === true) {
                /*
                **  guarded-Felder dürfen in der Request-Klasse keine Rule erhalten.
                **
                **  Früher wurde die Rule "missing" eingesetzt. Damit sollte erreicht werden,
                **  dass die Felder nicht in den Request-Daten enthalten sind, damit sie nicht
                **  über die Api verändert werden. Das funktioniert so aber nicht.
                **  Selbst wenn die Felder gar nicht in den Request-Daten enthalten sind, wird
                **  ein Fehler gemeldet, wenn eine korrespondierende Rule vorhanden ist. */
                continue;
            }
            $columnName = $Field->getAttribute('columnName');

            if (isset($skipColumns[$columnName])) {
                continue;
            }
            $nameCamelCase = $Field->getAttribute('name', CaseStyle::Camel);

            if ($Field->getAttribute('isForeignKey')) {
                /*
                **  Die ForeignKey-Felder werden hier nur gesammelt aber nicht weiter verarbeitet.
                **  Verwendet wird die Liste anschließend in der Methode _prepareRuleReplacement(). */
                $relationName = $Field->getAttribute('relationName');

                $this->_foreignKeys[] = $relationName;
                $this->_maxFieldNameLength = max($this->_maxFieldNameLength, strlen($relationName));

                $this->_addUse('LaravelJsonApi\\Validation\\Rule as JsonApiRule');

                continue;
            }
            $this->_maxFieldNameLength = max($this->_maxFieldNameLength, strlen($nameCamelCase));

            $this->_prepareFieldRules($Field, $nameCamelCase);
        }
        $this->_initUses();

        return $this;

    } // _processFields()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Schema-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach ($this->_jsonApiServers as $server => $status) {
            if ($status === false) {
                continue;
            }
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $fileContents = parent::replacePlaceholder('namespace-addition', $server.'\\'.$this->_typeNamePlural, $baseFileContents);
            /*
            **  Schema-Klasse schreiben. */
            $this->_filePath = 'JsonApi/'.$server.'/'.$this->_typeNamePlural;

            parent::_writeFileContents($this->_Package, $this->_typeName.'Request.php', $fileContents);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RequestGenerator extends JsonApiFileGenerator {}
