<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApiGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     5.1.0 / 2025-03-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ServerGenerator extends JsonApiGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * @var     array $_externalTypes
     */
    private $_externalTypes = [];


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     string $_mainServer
     */
    protected $_mainServer;


    /**
     * @var     string $_projectPackageName
     */
    private $_projectPackageName;


    /**
     * @var     array $_schemaClasses
     */
    private $_schemaClasses = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiServer->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _addSchemaClass(string $package, $typeName, string $className, bool $isPackage): self
    {
        $this->_schemaClasses[$package][strtolower($typeName)] = [
            'class' => $className.'::class',
            'className' => $className,
            'isPackageClass' => $isPackage,
        ];
        return $this;

    } // _addSchemaClass()


    /**
     *
     * @param       string $package
     *
     * @param       bool $mainServer
     *
     * @return 	    string
     *
     * @version     3.2.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(string $package, bool $mainServer): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($mainServer === true) {
            $fileContents = file_get_contents($this->_stubPath.'/server.stub');
        } else {
            $fileContents = file_get_contents($this->_stubPath.'/sub-server.stub');
        }
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('main-server', $this->_mainServer, $fileContents);
        $fileContents = parent::replacePlaceholder('schema-classes', $this->_prepareSchemaReplacement($package, $mainServer), $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $ProjectPackage = CodeGenerator::getProjectPackage();

        $this->_projectPackageName = $ProjectPackage->getName();

        $this->_initMainServer();

        return $this;

    } // _init()


    /**
     *
     * @todo        Diese Funktionalität sollte eventuell in die Klasse JsonApiGenerator verlagert
     *              werden.
     *              Dabei sollte dann auch unbedingt geprüft werden ob überhaupt einer der Server
     *              aktiv ist, und wenn nicht, dann sollte der erste Server im Array auf aktiv gesetzt
     *              werden.
     *              ACHTUNG: Eventuell kann es Gründe geben, beziehungsweise sinnvoll sein, keinen
     *                       Server zu aktivieren (Steuerung der Erzeugung von Klassen). Das muss
     *                       vorher geprüft und durchdacht werden.
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initMainServer(): self
    {
        foreach ($this->_jsonApiServers as $server => $status) {
            if ($status === true) {
                /*
                **  Der erste aktive Server wird als Haupserver verwendet. */
                $this->_mainServer = $server;

                return $this;
            }
        }
        /*
        **  Wenn keiner der Server aktiv ist, dann wird der erste Server aus der
        **  Liste verwendet. */
        reset($this->_jsonApiServers);

        $this->_mainServer = key($this->_jsonApiServers);

        return $this;

    } // _initMainServer()


    /**
     *
     * @param       string $package
     *
     * @param       bool $mainServer
     *
     * @return 	    string
     *
     * @version     3.0.0 / 2025-02-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareSchemaReplacement(string $package, bool $mainServer): string
    {
        ksort($this->_schemaClasses[$package]);

        $padding = str_repeat(' ', 12);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_schemaClasses[$package] as $schemaClass) {
            if ($mainServer === true) {
                $replacement .= "\n".$padding.$schemaClass['class'].',';

            } else {
                /*
                **  Package-Schemas werden in der Server-Klasse des Sub-Servers nicht eingebunden. */
                if ($schemaClass['isPackageClass'] === true) {
                    continue;
                }
                /*
                **  @todo   In einer weiteren Ausbaustufe könnten die individuellen Schema-Klassen auch
                **          in der Definition in der Migration angeben werden, um die SubServer-Klasse
                **          dauerhaft automatisch erzeugen zu können. */
                $replacement .= "\n".$padding."'".'App\\\\'.$this->_jsonApiNameSpace
                    .'\\\\'.$this->_mainServer
                    .'\\\\'.str_replace('\\', '\\\\', $schemaClass['className'])."'".' => '.$schemaClass['class'].',';
            }
        }
        return $replacement;

    } // _prepareSchemaReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processTypes();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-08
     * @history     ServerGenerator::_processTypeDefinitions(), 1.8.0 / 2025-02-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processTypes(): self
    {
        foreach ($this->_types as $Type) {
            $typeName = $Type->getBaseName(CaseStyle::Studly, Number::Singular);
            $typeNamePlural = $Type->getBaseName(CaseStyle::Studly, Number::Plural);

            $Package = $Type->getPackage();

            $packageName = $Package->getName();

            if ($Type->isForPackage() === true) {
                /*
                **  Wenn der aktuelle Typ zu einem Package gehört, dann muss er auch im Projekt verfügbar
                **  gemacht werden. Zu diesem Zweck werden die benötigten Informationen dazu hier in
                **  $_externalTypes zwischengespeichert. */
                $this->_externalTypes[$typeName] = [
                    'packageNamespace' => $Package->getNamespace(),
                    'typeName' => $typeName,
                    'typeNamePlural' => $typeNamePlural,
                ];
                $className = $typeName.'Schema';

                $this->_addSchemaClass($this->_projectPackageName, $typeName, $className, true);

            } else {
                $packageName = $this->_projectPackageName;
            }
            $this->_packages[$packageName] = $Package;

            $className = $typeName.'Schema';

            $this->_addSchemaClass($packageName, $typeName, $typeNamePlural.'\\'.$className, false);
        }
        return $this;

    } // _processTypes()


    /**
     *
     * @return 	    $this
     *
     * @version     1.11.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        /*
        **  Server-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach ($this->_jsonApiServers as $server => $status) {
            /*
            **  Pakete abarbeiten. */
            foreach ($this->_packages as $Package) {
                $packageName = $Package->getName();
                /*
                **  Die use-Anweisungen müssen für jedes Package neu aufgebaut werden. */
                $this->_resetUses();
                $this->_addUse('Illuminate\\Support\\Facades\\Auth');

                if ($status === true) {
                    $this->_addUse('LaravelJsonApi\\Core\\Server\\Server as BaseServer');

                } else {
                    /*
                    **  Bei inaktiven Servern wird die Server-Klasse des MainServers als
                    **  Basisklasse verwendet. */
                    $this->_addUse('App\\'.$this->_jsonApiNameSpace.'\\'.$this->_mainServer.'\\Server as BaseServer');
                }
                /*
                **  Wenn die Server-Klasse des Projekts erzeugt wird, dann müssen gegebenenfalls
                **  auch noch Types externer Pakete verarbeitet werden. */
                if ($Package->isForProject()) {
                    /*
                    **  Vorhandene externe Types abarbeiten um die passenden use-Anweisungen
                    **  in der projektspezifischen Server-Klasse einzufügen. */
                    foreach ($this->_externalTypes as $typeData) {
                        $packageNamespace = $typeData['packageNamespace'];
                        $typeName = $typeData['typeName'];
                        $typeNamePlural = $typeData['typeNamePlural'];
                        /*
                        **  Use-Direktive für die Schema-Klasse erzeugen.  */
                        $packageUse = $packageNamespace.'\\'.$this->_jsonApiNameSpace.'\\'
                            .$server.'\\'.$typeNamePlural.'\\'.$typeName.'Schema';

                        if (!class_exists($packageUse)) {
                            /*
                            **  Wenn die Schema-Klasse des Pakets beim aktuellen Server nicht existiert,
                            **  dann wird die entsprechende Schema-Klasse des MainServers eingebunden. */
                            $packageUse = $packageNamespace.'\\'.$this->_jsonApiNameSpace.'\\'
                                .$this->_mainServer.'\\'.$typeNamePlural.'\\'.$typeName.'Schema';
                        }
                        $this->_addUse($packageUse);
                    }
                }
                $namespace = $Package->getNamespace().'\\'.$this->_jsonApiNameSpace.'\\'.$server;

                $this->_baseDir = $Package->getBaseDir();
                /*
                **  Vorbereiteten Dateiinhalt ermitteln und server-spezifische Ersetzungen durchführen. */
                $baseFileContents = $this->_getPreparedFileContents($packageName, $status);

                $fileContents = parent::replacePlaceholder('lower-server', strtolower($server), $baseFileContents);
                $fileContents = parent::replacePlaceholder('namespace', $namespace, $fileContents);
                /*
                **  Server-Klasse schreiben. */
                $this->_filePath = 'JsonApi/'.$server;

                parent::_writeFileContents($Package, 'Server.php', $fileContents);
            }
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ServerGenerator extends JsonApiGenerator {}
