<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     3.6.0 / 2025-03-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ServiceGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_actionNamespace
     */
    private $_actionNamespace;


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Services';


    /**
     * @var     string $_modelNamespace
     */
    private $_modelNamespace;


    /**
     * @var     string $_typeNameCamel
     */
    protected $_typeNameCamel;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelService->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     2.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        if ($Type->hasExclude(Generator::LaravelActionCreate)
         && $Type->hasExclude(Generator::LaravelActionDelete)
         && $Type->hasExclude(Generator::LaravelActionUpdate)) {
            $this->_exclude = true;
        }
        parent::__construct($Type);

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.3.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/service.stub');
        /*
        **  Die Methoden-Templates müssen zuerst eingefügt werden, damit im Anschluss auch die darin verwendeten
        **  Platzhalter ersetzt werden. */
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('action-namespace', $this->_actionNamespace, $fileContents);
        $fileContents = parent::replacePlaceholder('model-namespace', $this->_modelNamespace, $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name-camel', $this->_typeNameCamel, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_actionNamespace = $packageNamespace.'\\Actions';
        $this->_modelNamespace = $packageNamespace.'\\Models';
        $this->_namespace = $packageNamespace.'\\Services';

        $this->_typeNameCamel = $this->_Type->getBaseName(CaseStyle::Camel, Number::Singular);

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        if ($this->_Type->hasExclude(Generator::LaravelActionCreate) === false) {
            $this->_addUse($this->_actionNamespace.'\\'.$this->_typeName.'\\Create');
        }
        if ($this->_Type->hasExclude(Generator::LaravelActionDelete) === false) {
            $this->_addUse($this->_actionNamespace.'\\'.$this->_typeName.'\\Delete');
        }
        if ($this->_Type->hasExclude(Generator::LaravelActionUpdate) === false) {
            $this->_addUse($this->_actionNamespace.'\\'.$this->_typeName.'\\Update');
        }
        $this->_addUse($this->_modelNamespace.'\\'.$this->_typeName);

        return parent::_initUses();

    } // _initUses()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.4.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareMethodReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Action-Methoden zusammenstellen. */
        $replacement = '';

        if ($this->_Type->hasExclude(Generator::LaravelActionCreate) === false) {
            $replacement .= file_get_contents($this->_stubPath.'/snippets/service/method.create.stub');
        }
        if ($this->_Type->hasExclude(Generator::LaravelActionDelete) === false) {
            $replacement .= file_get_contents($this->_stubPath.'/snippets/service/method.delete.stub');
        }
        if ($this->_Type->hasExclude(Generator::LaravelActionUpdate) === false) {
            $replacement .= file_get_contents($this->_stubPath.'/snippets/service/method.update.stub');
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Service-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Service.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ServiceGenerator extends LaravelFileGenerator {}
