<?php
/**
 * WinMerge Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\WinMerge;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\WinMergeGenerator;


/**
 * WinMerge Code Generator Class
 *
 * @version     1.2.0 / 2025-03-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CompareFileGenerator extends WinMergeGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'etc';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::WinMerge->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        foreach ($this->_types as $Type) {
            $Package = $Type->getPackage();

            $packageName = $Package->getName();

            $this->_packages[$packageName] = $Package;
        }
        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $paths = [
            'app' => 'app',
            'routes' => 'routes',
        ];
        $baseFileContents = file_get_contents($this->_stubPath.'/compare.stub');
        /*
        **  Pfade abarbeiten. */
        foreach ($this->_packages as $packageName => $Package) {
            foreach ($paths as $filename => $path) {
                $fileContents = parent::replacePlaceholder('code-path', '..\\'.$path.'\\', $baseFileContents);
                $fileContents = parent::replacePlaceholder('build-path', '..\\storage\\app\\build\\CodeGenerator\\'.$path.'\\', $fileContents);
                /*
                **  Compare-Datei schreiben. */
                parent::_writeFileContents($Package, $filename.'.WinMerge', $fileContents);
            }
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CompareFileGenerator extends WinMergeGenerator {}
