<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Generators\CodeGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.0 / 2025-04-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DerivedPolicyGenerator extends PolicyGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias = 'PackagePolicy';


    /**
     * @var     GeneratorMode $_GeneratorMode
     */
    protected $_GeneratorMode = GeneratorMode::Derived;


    /**
     * @var     string $_originalPackageName
     */
    protected $_originalPackageName;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiDerivedPolicy->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_originalPackageName = $this->_packageName;

        $baseClass = $this->_typeName.'Policy';

        $this->_addUse($this->_packageNamespace.'\\'.$this->_jsonApiNameSpace.'\\'.$this->_typeNamePlural.'\\'.$baseClass.' as '.$this->_baseClassAlias);
        /*
        **  Originales Package durch das Projekt-Package ersetzen. */
        $this->_Package = CodeGenerator::getProjectPackage();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $this->_packageNamespace.'\\Models';
        $this->_namespace = $this->_packageNamespace.'\\Policies';

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Policy-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Policy.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class DerivedPolicyGenerator extends PolicyGenerator {}
